#include "gmbCommon.h"
#include "gmbIndexedList.h"
#include "btBulletDynamicsCommon.h"

gmbIndexedListUnRef<btCollisionObject*> gmbGlobal_CollisionBodies;

//Kinetmatic Body Functions
GM_export GM_Real GMBULLET_SetPosition(GM_Real ID,GM_Real x, GM_Real y, GM_Real z)
{
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;
	
	btTransform tt=body->getWorldTransform();
	tt.setOrigin(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
	body->setWorldTransform(tt);
	return 0;
}
GM_export GM_Real GMBULLET_SetPositionX(GM_Real ID,GM_Real x)
{
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;
	
	btTransform tt=body->getWorldTransform();
	btVector3 torig=tt.getOrigin();
	torig.setX(btScalar(x)*invDistanceScale);
	tt.setOrigin(torig);
	body->setWorldTransform(tt);
	return 0;
}
GM_export GM_Real GMBULLET_SetPositionY(GM_Real ID,GM_Real y)
{
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;
	
	btTransform tt=body->getWorldTransform();
	btVector3 torig=tt.getOrigin();
	torig.setY(btScalar(y)*invDistanceScale);
	tt.setOrigin(torig);
	body->setWorldTransform(tt);
	return 0;
}
GM_export GM_Real GMBULLET_SetPositionZ(GM_Real ID,GM_Real z)
{
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;
	
	btTransform tt=body->getWorldTransform();
	btVector3 torig=tt.getOrigin();
	torig.setY(btScalar(z)*invDistanceScale);
	tt.setOrigin(torig);
	body->setWorldTransform(tt);
	return 0;
}
GM_export GM_Real GMBULLET_SetRelativePosition(GM_Real ID,GM_Real x, GM_Real y, GM_Real z)
{
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;
	
	btTransform tt=body->getWorldTransform();
	tt.setOrigin(tt.getOrigin()+btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
	body->setWorldTransform(tt);
	return 0;
}
GM_export GM_Real GMBULLET_ClearRotation(GM_Real ID)
{
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;

	btTransform tt=body->getWorldTransform();
	tt.setRotation(btQuaternion(0,0,0));
	body->setWorldTransform(tt);
	return 0;
}
GM_export GM_Real GMBULLET_AddArbitraryRotation(GM_Real ID,GM_Real x,GM_Real y,GM_Real z,GM_Real angle)
{
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;

	btTransform tt=body->getWorldTransform();
	tt*=btTransform(btQuaternion(btVector3(btScalar(x),btScalar(y),btScalar(z)),btScalar(angle)*invAngleMultiplier));
	body->setWorldTransform(tt);
	return 0;
}
GM_export GM_Real GMBULLET_AddRotationWithFlags(GM_Real ID,GM_Real r1,GM_Real r2,GM_Real r3)
{	
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;

	btTransform tt=body->getWorldTransform();
	tt.setBasis(RotationWithFlags(btScalar(r1),btScalar(r2),btScalar(r3),tt.getBasis()));
	body->setWorldTransform(tt);
	return 0;
}
GM_export GM_Real GMBULLET_SetArbitraryRotation(GM_Real ID,GM_Real x,GM_Real y,GM_Real z,GM_Real angle)
{
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;

	btTransform tt=body->getWorldTransform();
	tt.setRotation(btQuaternion(btVector3(btScalar(x),btScalar(y),btScalar(z)),btScalar(angle)*invAngleMultiplier));
	body->setWorldTransform(tt);
	return 0;
}
GM_export GM_Real GMBULLET_SetRotationWithFlags(GM_Real ID,GM_Real r1,GM_Real r2,GM_Real r3)
{
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;

	btTransform tt=body->getWorldTransform();
	tt.setBasis(RotationWithFlags(btScalar(r1),btScalar(r2),btScalar(r3)));
	body->setWorldTransform(tt);
	return 0;
}
GM_export GM_Real GMBULLET_SetBodyPosFromStack(GM_Real stackID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		while(ds_stack_size(stackID)>=4)
		{
			btScalar tz=btScalar(ds_stack_pop(stackID));
			btScalar ty=btScalar(ds_stack_pop(stackID));
			btScalar tx=btScalar(ds_stack_pop(stackID));
			btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(body)
			{
				retval++;
				btTransform tt=body->getWorldTransform();
				tt.setOrigin(tt.getOrigin()+btVector3(tx,ty,tz)*invDistanceScale);
				body->setWorldTransform(tt);
			}
		}
	}
	else
	{
		while(ds_stack_size(stackID)>=4)
		{
			btScalar tz=btScalar(ds_stack_pop(stackID));
			btScalar ty=btScalar(ds_stack_pop(stackID));
			btScalar tx=btScalar(ds_stack_pop(stackID));
			btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(body)
			{
				retval++;
				btTransform tt=body->getWorldTransform();
				tt.setOrigin(btVector3(tx,ty,tz)*invDistanceScale);
				body->setWorldTransform(tt);
			}
		}
	}
	return retval;
}
GM_export GM_Real GMBULLET_SetBodyRotWFFromStack(GM_Real stackID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		while(ds_stack_size(stackID)>=4)
		{
			btScalar tz=btScalar(ds_stack_pop(stackID));
			btScalar ty=btScalar(ds_stack_pop(stackID));
			btScalar tx=btScalar(ds_stack_pop(stackID));
			btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(body)
			{
				retval++;
				btTransform tt=body->getWorldTransform();
				tt.setBasis(RotationWithFlags(tx,ty,tz,tt.getBasis()));
				body->setWorldTransform(tt);
			}
		}
	}
	else
	{
		while(ds_stack_size(stackID)>=4)
		{
			btScalar tz=btScalar(ds_stack_pop(stackID));
			btScalar ty=btScalar(ds_stack_pop(stackID));
			btScalar tx=btScalar(ds_stack_pop(stackID));
			btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(body)
			{
				retval++;
				btTransform tt=body->getWorldTransform();
				tt.setBasis(RotationWithFlags(tx,ty,tz));
				body->setWorldTransform(tt);
			}
		}
	}
	return retval;
}
GM_export GM_Real GMBULLET_SetBodyPosRotWFFromStack(GM_Real stackID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		while(ds_stack_size(stackID)>=4)
		{
			btScalar trotz=btScalar(ds_stack_pop(stackID));
			btScalar troty=btScalar(ds_stack_pop(stackID));
			btScalar trotx=btScalar(ds_stack_pop(stackID));
			btScalar tposz=btScalar(ds_stack_pop(stackID));
			btScalar tposy=btScalar(ds_stack_pop(stackID));
			btScalar tposx=btScalar(ds_stack_pop(stackID));
			btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(body)
			{
				retval++;
				btTransform tt=body->getWorldTransform();
				tt.setOrigin(tt.getOrigin()+btVector3(tposx,tposy,tposz)*invDistanceScale);
				tt.setBasis(RotationWithFlags(trotx,troty,trotz,tt.getBasis()));
				body->setWorldTransform(tt);
			}
		}
	}
	else
	{
		while(ds_stack_size(stackID)>=4)
		{
			btScalar trotz=btScalar(ds_stack_pop(stackID));
			btScalar troty=btScalar(ds_stack_pop(stackID));
			btScalar trotx=btScalar(ds_stack_pop(stackID));
			btScalar tposz=btScalar(ds_stack_pop(stackID));
			btScalar tposy=btScalar(ds_stack_pop(stackID));
			btScalar tposx=btScalar(ds_stack_pop(stackID));
			btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(body)
			{
				retval++;
				btTransform tt=body->getWorldTransform();
				tt.setOrigin(btVector3(tposx,tposy,tposz)*invDistanceScale);
				tt.setBasis(RotationWithFlags(trotx,troty,trotz));
				body->setWorldTransform(tt);
			}
		}
	}
	return retval;
}

GM_export GM_Real GMBULLET_SetBodyPosFromList(GM_Real listID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		int i=0;
		while(i<=(ds_list_size(listID)-4))
		{
			btCollisionObject* body=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(body)
			{
				retval++;
				btTransform tt=body->getWorldTransform();
				tt.setOrigin(tt.getOrigin()+btVector3(btScalar(ds_list_find_value(listID,i++)),
					btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)))*invDistanceScale);
				body->setWorldTransform(tt);
			}
			else
			{
				i+=3;
			}
		}
	}
	else
	{
		int i=0;
		while(i<=(ds_list_size(listID)-4))
		{
			btCollisionObject* body=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(body)
			{
				retval++;
				btTransform tt=body->getWorldTransform();
				tt.setOrigin(btVector3(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
					btScalar(ds_list_find_value(listID,i++)))*invDistanceScale);
				body->setWorldTransform(tt);
			}
			else
			{
				i+=3;
			}
		}
	}
	return retval;
}
GM_export GM_Real GMBULLET_SetBodyRotWFFromList(GM_Real listID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		int i=0;
		while(i<=(ds_list_size(listID)-4))
		{
			btCollisionObject* body=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(body)
			{
				retval++;
				btTransform tt=body->getWorldTransform();
				tt.setBasis(RotationWithFlags(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
					btScalar(ds_list_find_value(listID,i++)),tt.getBasis()));
				body->setWorldTransform(tt);
			}
			else
			{
				i+=3;
			}
		}
	}
	else
	{
		int i=0;
		while(i<=(ds_list_size(listID)-4))
		{
			btCollisionObject* body=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(body)
			{
				retval++;
				btTransform tt=body->getWorldTransform();
				tt.setBasis(RotationWithFlags(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
					btScalar(ds_list_find_value(listID,i++))));
				body->setWorldTransform(tt);
			}
			else
			{
				i+=3;
			}
		}
	}
	return retval;
}
GM_export GM_Real GMBULLET_SetBodyPosRotWFFromList(GM_Real listID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		int i=0;
		while(i<=(ds_list_size(listID)-4))
		{
			btCollisionObject* body=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(body)
			{
				retval++;
				btTransform tt=body->getWorldTransform();
				tt.setOrigin(tt.getOrigin()+btVector3(btScalar(ds_list_find_value(listID,i++)),
					btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)))*invDistanceScale);
				tt.setBasis(RotationWithFlags(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
					btScalar(ds_list_find_value(listID,i++)),tt.getBasis()));
				body->setWorldTransform(tt);
			}
			else
			{
				i+=3;
			}
		}
	}
	else
	{
		int i=0;
		while(i<=(ds_list_size(listID)-4))
		{
			btCollisionObject* body=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(body)
			{
				retval++;
				btTransform tt=body->getWorldTransform();
				tt.setOrigin(btVector3(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
						btScalar(ds_list_find_value(listID,i++)))*invDistanceScale);
				tt.setBasis(RotationWithFlags(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
						btScalar(ds_list_find_value(listID,i++))));
				body->setWorldTransform(tt);
			}
			else
			{
				i+=3;
			}
		}
	}
	return retval;
}

//Dynamic Body Functions
GM_export GM_Real GMBULLET_SetAngularFactor(GM_Real ID,GM_Real angFact)
{
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;
	body->setAngularFactor(btScalar(angFact));
	return 0;
}
GM_export GM_Real GMBULLET_SetAngularVelocityX(GM_Real ID,GM_Real x)
{
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;
	btVector3 tv=body->getLinearVelocity();
	tv.setX(btScalar(x)*invAngleMultiplier);
	body->setsetAngularVelocity(tv);
	body->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_SetAngularVelocityY(GM_Real ID,GM_Real y)
{
	btCollisionObject* body=gmbGlobal_CollisionBodies.GetInstance(unsigned int(ID));
	if(!body)
		return -1;
	btVector3 tv=body->getLinearVelocity();
	tv.setY(btScalar(y)*invAngleMultiplier);
	tb->setAngularVelocity(tv);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_SetAngularVelocityZ(GM_Real ID,GM_Real z)
{
	
		
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	btVector3 tv=tb->getLinearVelocity();
	tv.setZ(btScalar(z)*invAngleMultiplier);
	tb->setAngularVelocity(tv);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_SetAngularVelocity(GM_Real ID,GM_Real x,GM_Real y,GM_Real z)
{	
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	tb->setAngularVelocity(btVector3(btScalar(x),btScalar(y),btScalar(z))*invAngleMultiplier);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_AddAngularVelocity(GM_Real ID,GM_Real x,GM_Real y,GM_Real z)
{	
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	tb->setAngularVelocity(tb->getAngularVelocity()+btVector3(btScalar(x),btScalar(y),btScalar(z))*invAngleMultiplier);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_ApplyTorqueImpulse(GM_Real ID,GM_Real x,GM_Real y,GM_Real z)
{
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	tb->applyTorqueImpulse(btVector3(btScalar(x),btScalar(y),btScalar(z))*invAngleMultiplier*invDistanceScale*invDistanceScale);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_SetLinearVelocityX(GM_Real ID,GM_Real x)
{
	
		
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	btVector3 tv=tb->getLinearVelocity();
	tv.setX(btScalar(x)*invDistanceScale);
	tb->setLinearVelocity(tv);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_SetLinearVelocityY(GM_Real ID,GM_Real y)
{
	
		
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	btVector3 tv=tb->getLinearVelocity();
	tv.setY(btScalar(y)*invDistanceScale);
	tb->setLinearVelocity(tv);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_SetLinearVelocityZ(GM_Real ID,GM_Real z)
{
	
		
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	btVector3 tv=tb->getLinearVelocity();
	tv.setZ(btScalar(z)*invDistanceScale);
	tb->setLinearVelocity(tv);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_SetLinearVelocity(GM_Real ID,GM_Real x,GM_Real y,GM_Real z)
{

	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	tb->setLinearVelocity(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_AddLinearVelocity(GM_Real ID,GM_Real x,GM_Real y,GM_Real z)
{
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	tb->setLinearVelocity(tb->getLinearVelocity()+btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_ApplyCentralImpulse(GM_Real ID,GM_Real x,GM_Real y,GM_Real z)
{
	
		
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	tb->applyCentralImpulse(btVector3(btScalar(x),btScalar(y),btScalar(z))*invDistanceScale);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_ApplyImpulse(GM_Real ID,GM_Real impulse_x,GM_Real impulse_y,GM_Real impulse_z,GM_Real posx,GM_Real posy,GM_Real posz,GM_Real relative)
{
	
		
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	btVector3 tv=btVector3(btScalar(posx),btScalar(posy),btScalar(posz)*invDistanceScale);
	if(!relative)
		tv-=tb->getCenterOfMassPosition();
	tb->applyImpulse(btVector3(btScalar(impulse_x),btScalar(impulse_y),btScalar(impulse_z))*invDistanceScale,tv);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_ApplyImpulseFromSpeedAndMass(GM_Real ID,GM_Real velocity_x,GM_Real velocity_y,GM_Real velocity_z,GM_Real mass,GM_Real posx,GM_Real posy,GM_Real posz,GM_Real relative)
{
	
		
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	btVector3 tv=btVector3(btScalar(posx),btScalar(posy),btScalar(posz)*invDistanceScale);
	if(!relative)
		tv-=tb->getCenterOfMassPosition();
	tb->applyImpulse(btVector3(btScalar(velocity_x),btScalar(velocity_y),btScalar(velocity_z))*btScalar(mass),tv);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_AddVelocityAtPoint(GM_Real ID,GM_Real velocity_x,GM_Real velocity_y,GM_Real velocity_z,GM_Real posx,GM_Real posy,GM_Real posz,GM_Real relative)
{
	
		
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	btVector3 tv=btVector3(btScalar(posx),btScalar(posy),btScalar(posz)*invDistanceScale);
	if(!relative)
		tv-=tb->getCenterOfMassPosition();
	tb->setAngularVelocity(tb->getAngularVelocity()+tv.cross(btVector3(btScalar(velocity_x),btScalar(velocity_y),btScalar(velocity_z))*invDistanceScale));
	tb->setLinearVelocity(tb->getLinearVelocity()+btVector3(btScalar(velocity_x),btScalar(velocity_y),btScalar(velocity_z))*invDistanceScale);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_SetGravityX(GM_Real ID,GM_Real x)
{
	
		
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	btVector3 tv=tb->getGravity();
	tv.setX(btScalar(x));
	tb->setGravity(tv);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_SetGravityY(GM_Real ID,GM_Real y)
{
	
		
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	btVector3 tv=tb->getGravity();
	tv.setY(btScalar(y));
	tb->setGravity(tv);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_SetGravityZ(GM_Real ID,GM_Real z)
{
	
		
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	btVector3 tv=tb->getGravity();
	tv.setZ(btScalar(z));
	tb->setGravity(tv);
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_SetGravity(GM_Real ID,GM_Real x,GM_Real y,GM_Real z)
{
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	tb->setGravity(btVector3(btScalar(x),btScalar(y),btScalar(z)));
	tb->activate(1);
	return 0;
}
GM_export GM_Real GMBULLET_AddGravity(GM_Real ID,GM_Real x,GM_Real y,GM_Real z)
{
		
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -2;
	tb->setGravity(tb->getGravity()+btVector3(btScalar(x),btScalar(y),btScalar(z)));
	tb->activate(1);
	return 0;
}

GM_export GM_Real GMBULLET_SetBodyLinVelFromStack(GM_Real stackID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		while(ds_stack_size(stackID)>=4)
		{
			btScalar tz=float(ds_stack_pop(stackID));
			btScalar ty=float(ds_stack_pop(stackID));
			btScalar tx=float(ds_stack_pop(stackID));
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(tb)
			{
				retval++;
				tb->setLinearVelocity(tb->getLinearVelocity()+btVector3(tx,ty,tz)*invDistanceScale);
				tb->activate(1);
			}
		}
	}
	else
	{
		while(ds_stack_size(stackID)>=4)
		{
			btScalar tz=float(ds_stack_pop(stackID));
			btScalar ty=float(ds_stack_pop(stackID));
			btScalar tx=float(ds_stack_pop(stackID));
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(tb)
			{
				retval++;
				tb->setLinearVelocity(btVector3(tx,ty,tz)*invDistanceScale);
				tb->activate(1);
			}
		}
	}
	return retval;
}
GM_export GM_Real GMBULLET_SetBodyAngVelFromStack(GM_Real stackID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		while(ds_stack_size(stackID)>=4)
		{
			btScalar tz=float(ds_stack_pop(stackID));
			btScalar ty=float(ds_stack_pop(stackID));
			btScalar tx=float(ds_stack_pop(stackID));
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(tb)
			{
				retval++;
				tb->setAngularVelocity(tb->getAngularVelocity()+btVector3(tx,ty,tz)*invAngleMultiplier);
				tb->activate(1);
			}
		}
	}
	else
	{
		while(ds_stack_size(stackID)>=4)
		{
			btScalar tz=float(ds_stack_pop(stackID));
			btScalar ty=float(ds_stack_pop(stackID));
			btScalar tx=float(ds_stack_pop(stackID));
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(tb)
			{
				retval++;
				tb->setAngularVelocity(btVector3(tx,ty,tz)*invAngleMultiplier);
				tb->activate(1);
			}
		}
	}
	return retval;
}
GM_export GM_Real GMBULLET_SetBodyLinAngVelFromStack(GM_Real stackID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		while(ds_stack_size(stackID)>=7)
		{
			btScalar trotz=float(ds_stack_pop(stackID));
			btScalar troty=float(ds_stack_pop(stackID));
			btScalar trotx=float(ds_stack_pop(stackID));
			btScalar tpz=float(ds_stack_pop(stackID));
			btScalar tpy=float(ds_stack_pop(stackID));
			btScalar tpx=float(ds_stack_pop(stackID));
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(tb)
			{
				retval++;
				tb->setLinearVelocity(tb->getLinearVelocity()+btVector3(tpx,tpy,tpz)*invDistanceScale);
				tb->setAngularVelocity(tb->getAngularVelocity()+btVector3(trotx,troty,trotz)*invAngleMultiplier);
				tb->activate(1);
			}
		}
	}
	else
	{
		while(ds_stack_size(stackID)>=7)
		{
			btScalar trotz=float(ds_stack_pop(stackID));
			btScalar troty=float(ds_stack_pop(stackID));
			btScalar trotx=float(ds_stack_pop(stackID));
			btScalar tpz=float(ds_stack_pop(stackID));
			btScalar tpy=float(ds_stack_pop(stackID));
			btScalar tpx=float(ds_stack_pop(stackID));
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(tb)
			{
				retval++;
				tb->setLinearVelocity(btVector3(tpx,tpy,tpz)*invDistanceScale);
				tb->setAngularVelocity(btVector3(trotx,troty,trotz)*invAngleMultiplier);
				tb->activate(1);
			}
		}
	}
	return retval;
}
GM_export GM_Real GMBULLET_SetBodyGravityFromStack(GM_Real stackID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		while(ds_stack_size(stackID)>=4)
		{
			btScalar tz=float(ds_stack_pop(stackID));
			btScalar ty=float(ds_stack_pop(stackID));
			btScalar tx=float(ds_stack_pop(stackID));
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(tb)
			{
				retval++;
				tb->setGravity(tb->getGravity()+btVector3(tx,ty,tz));
				tb->activate(1);
			}
		}
	}
	else
	{
		while(ds_stack_size(stackID)>=4)
		{
			btScalar tz=float(ds_stack_pop(stackID));
			btScalar ty=float(ds_stack_pop(stackID));
			btScalar tx=float(ds_stack_pop(stackID));
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_stack_pop(stackID)));
			if(tb)
			{
				retval++;
				tb->setGravity(btVector3(tx,ty,tz));
				tb->activate(1);
			}
		}
	}
	return retval;
}
GM_export GM_Real GMBULLET_SetBodyLinVelFromList(GM_Real listID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		int i=0;
		while(i<=(ds_list_size(listID)-4))
		{
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(tb)
			{
				retval++;
				tb->setLinearVelocity(tb->getLinearVelocity()+btVector3(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
						btScalar(ds_list_find_value(listID,i++)))*invDistanceScale);
				tb->activate(1);
			}
			else
			{
				i+=3;
			}
		}
	}
	else
	{
		int i=0;
		while(i<=(ds_list_size(listID)-4))
		{
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(tb)
			{
				retval++;
				tb->setLinearVelocity(btVector3(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
						btScalar(ds_list_find_value(listID,i++)))*invDistanceScale);
				tb->activate(1);
			}
			else
			{
				i+=3;
			}
		}
	}
	return retval;
}
GM_export GM_Real GMBULLET_SetBodyAngVelFromList(GM_Real listID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		int i=0;
		while(i<=(ds_list_size(listID)-4))
		{
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(tb)
			{
				retval++;
				tb->setAngularVelocity(tb->getAngularVelocity()+btVector3(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
						btScalar(ds_list_find_value(listID,i++)))*invAngleMultiplier);
				tb->activate(1);
			}
			else
			{
				i+=3;
			}
		}
	}
	else
	{
		int i=0;
		while(i<=(ds_list_size(listID)-4))
		{
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(tb)
			{
				retval++;
				tb->setAngularVelocity(btVector3(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
						btScalar(ds_list_find_value(listID,i++)))*invDistanceScale);
				tb->activate(1);
			}
			else
			{
				i+=3;
			}
		}
	}
	return retval;
}
GM_export GM_Real GMBULLET_SetBodyLinAngVelFromList(GM_Real listID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		int i=0;
		while(i<=(ds_list_size(listID)-7))
		{
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(tb)
			{
				retval++;
				tb->setLinearVelocity(tb->getLinearVelocity()+btVector3(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
						btScalar(ds_list_find_value(listID,i++)))*invDistanceScale);
				tb->setAngularVelocity(tb->getAngularVelocity()+btVector3(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
						btScalar(ds_list_find_value(listID,i++)))*invAngleMultiplier);
				tb->activate(1);
			}
			else
			{
				i+=3;
			}
		}
	}
	else
	{
		int i=0;
		while(i<=(ds_list_size(listID)-7))
		{
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(tb)
			{
				retval++;
				tb->setLinearVelocity(btVector3(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
						btScalar(ds_list_find_value(listID,i++)))*invDistanceScale);
				tb->setAngularVelocity(btVector3(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
						btScalar(ds_list_find_value(listID,i++)))*invDistanceScale);
				tb->activate(1);
			}
			else
			{
				i+=3;
			}
		}
	}
	return retval;
}
GM_export GM_Real GMBULLET_SetBodyGravityFromList(GM_Real listID,GM_Real relative)
{
	int retval=0;
	if(relative)
	{
		int i=0;
		while(i<=(ds_list_size(listID)-4))
		{
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(tb)
			{
				retval++;
				tb->setGravity(tb->getGravity()+btVector3(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
						btScalar(ds_list_find_value(listID,i++)))*invDistanceScale);
				tb->activate(1);
			}
			else
			{
				i+=3;
			}
		}
	}
	else
	{
		int i=0;
		while(i<=(ds_list_size(listID)-4))
		{
			btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ds_list_find_value(listID,i++)));
			if(tb)
			{
				retval++;
				tb->setGravity(btVector3(btScalar(ds_list_find_value(listID,i++)),btScalar(ds_list_find_value(listID,i++)),
						btScalar(ds_list_find_value(listID,i++)))*invDistanceScale);
				tb->activate(1);
			}
			else
			{
				i+=3;
			}
		}
	}
	return retval;
}
