#include "gmbBSPLoader.h"
#include <stdio.h>
#include "gmbCommon.h"
#include "gmbShape.h"
#include "gmbShapeExports.h"

void gmbBSPConverter::addConvexVerticesCollider(btAlignedObjectArray<btVector3>& vertices, bool isEntity, const btVector3& entityTargetLocation)
{
	if (vertices.size() > 0)
	{
		btCollisionShape* tcs = new btConvexHullShape(&(vertices[0].getX()),vertices.size());
		shapeIDs->push_back(gmbGlobal_ShapeList.AddInstance(new gmbShape(tcs)));
	}
}

btAlignedObjectArray<unsigned int>* gmbBSPConverter::LoadBSP(char* filename,float scaling)
{
	unsigned char* memoryBuffer = 0;

	shapeIDs=new btAlignedObjectArray<unsigned int>();

	FILE* file = fopen(filename,"r");
	if (file)
	{
		int size=0;
		if (fseek(file, 0, SEEK_END) || (size = ftell(file)) == EOF || fseek(file, 0, SEEK_SET))
		{       
			fclose(file);
			return NULL;
		} 
		else
		{
			memoryBuffer = new unsigned char[(size+1)];
			fread(memoryBuffer,1,size,file);
			fclose(file);
			if(!loadBSPFile((void*)memoryBuffer))
			{
				delete memoryBuffer;
				return NULL;
			}
			convertBsp((*this),scaling);
			delete memoryBuffer;
			return shapeIDs;
		}
	}
	return NULL;
}
