#ifndef __3DS_MESH_LOADER__
#define __3DS_MESH_LOADER__

#include <stdio.h>
//#include <string>
#include "btBulletDynamicsCommon.h"

class gmb3DSMeshLoader
{
private:
	struct Face3DS
	{
		unsigned short a,b,c,i;
	};

	struct Vertex3DS
	{
		float x,y,z;
	};

	struct Mesh
	{
		//std::string MeshName;
		btAlignedObjectArray<btVector3> VertexList;
		btAlignedObjectArray<Face3DS> FaceList;
	};

	struct Chunk
	{
		unsigned short ID;
		unsigned int length;
	};

	void ReadObject(FILE* file,const unsigned int chunkend,Mesh* mesh);
	int ReadFile(const char* fname);

protected:
	virtual void MeshCallback(Mesh* mesh);

public:

	btAlignedObjectArray<btStridingMeshInterface*> meshlist;

	gmb3DSMeshLoader(){;}
	gmb3DSMeshLoader(const char* fname)
	{
		LoadFile(fname);
	}
	virtual ~gmb3DSMeshLoader(){;}

	int LoadFile(const char* fname);
};

#endif //__3DS_MESH_LOADER__