#include "gmb3DSMeshLoader.h"
#include "gmbTrimeshShape.h"

#define MAIN			0x4D4D
#define MAIN_EDIT		0x3D3D 
#define EDIT_OBJECT		0x4000
#define OBJECT_TRIMESH	0x4100
#define TRIMESH_VERTEX	0x4110
#define TRIMESH_FACE	0x4120

int gmb3DSMeshLoader::LoadFile(const char* fname)
{
	return ReadFile(fname);
}
int gmb3DSMeshLoader::ReadFile(const char* fname)
{
	FILE* file;
	Chunk currentChunk;
	int chunkend;
	fopen_s(&file,fname,"rb");
	if(!file)
		return -3;
	fread((void*)&currentChunk.ID,sizeof(unsigned short),1,file);
	fread((void*)&currentChunk.length,sizeof(unsigned int),1,file);
	if(currentChunk.ID!=MAIN)
		return -4;
	do{
		if(fread((void*)&currentChunk.ID,sizeof(unsigned short),1,file)!=1)
			break;
		if(fread((void*)&currentChunk.length,sizeof(unsigned int),1,file)!=1)
			break;
		int tlen=ftell(file);
		chunkend=tlen+currentChunk.length-6;
		Mesh tmesh;
		switch(currentChunk.ID)
		{
		case MAIN:
			break;
		case MAIN_EDIT:
			break;
		case EDIT_OBJECT:
			ReadObject(file,chunkend,&tmesh);
			if( (tmesh.FaceList.size()!=0) && (tmesh.VertexList.size()!=0) )
				MeshCallback(&tmesh);
		default:
			fseek(file,chunkend,SEEK_SET);
			break;
		}
	}while(!feof(file));
	fclose(file);
	return 0;
}


void gmb3DSMeshLoader::ReadObject(FILE* file,const unsigned int chunkend,Mesh* mesh)
{
	char tc;
	do{
		fread((void*)&tc,sizeof(char),1,file);
		//mesh->MeshName+=tc;
	}while(tc!='\0');

	Chunk currentChunk;
	while((ftell(file)<chunkend)&&(!feof(file)))
	{
		fread((void*)&currentChunk.ID,sizeof(unsigned short),1,file);
		fread((void*)&currentChunk.length,sizeof(unsigned int),1,file);
		int tlen=ftell(file);
		int chunkend2=tlen+currentChunk.length-6;
		switch(currentChunk.ID)
		{
		case OBJECT_TRIMESH:
			break;
		case TRIMESH_VERTEX:
			unsigned short numv;
			fread((void*)&numv,sizeof(unsigned short),1,file);
			for(int i=0;(unsigned int)i<numv;i++)
			{
				Vertex3DS tv;
				fread((void*)&tv.x,sizeof(float),1,file);
				fread((void*)&tv.y,sizeof(float),1,file);
				fread((void*)&tv.z,sizeof(float),1,file);
				mesh->VertexList.push_back(btVector3(tv.x,tv.y,tv.z));
			}
			break;
		case TRIMESH_FACE:
			unsigned short numf;
			fread((void*)&numf,sizeof(unsigned short),1,file);
			for(int i=0;(unsigned int)i<numf;i++)
			{
				Face3DS tf;
				fread((void*)&tf.a,sizeof(unsigned short),1,file);
				fread((void*)&tf.b,sizeof(unsigned short),1,file);
				fread((void*)&tf.c,sizeof(unsigned short),1,file);
				fread((void*)&tf.i,sizeof(unsigned short),1,file);
				mesh->FaceList.push_back(tf);
			}
			break;
		default:
			fseek(file,chunkend2,SEEK_SET);
			break;
		}	
	}
}

void gmb3DSMeshLoader::MeshCallback(Mesh* mesh)
{
	gmbIndexedTriangleMesh* ttm=new gmbIndexedTriangleMesh(false,false);
	ttm->preallocateVertices(mesh->VertexList.size());
	ttm->preallocateIndices(mesh->FaceList.size()*3);

	for(int i=0;i<mesh->VertexList.size();i++)
	{
		ttm->findOrAddVertex(mesh->VertexList[i],false);
	}
	for(int i=0;i<mesh->FaceList.size();i++)
	{
		ttm->addIndex(mesh->FaceList[i].a);
		ttm->addIndex(mesh->FaceList[i].b);
		ttm->addIndex(mesh->FaceList[i].c);
	}
	ttm->setNumTris(mesh->FaceList.size());
	meshlist.push_back(ttm);
}