#include "Win32Exports.h"
#ifdef _USING_WINDOWS_
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "DebugDrawer.h"
GM_export double GMBULLET_ImTopmost()
{
	return (GetForegroundWindow() == GetActiveWindow());
}

#endif

#ifdef _USING_DIRECTX_
IDirect3DDevice8* GMD3DDev=NULL;

GM_export double GMBULLET_GetGMD3DDevice(double gm_version)
{
	IDirect3DDevice8** addr;
	switch(int(gm_version))
	{
	case 0: //GM7
		addr=(IDirect3DDevice8**)5798500;
		GMD3DDev= *addr;
		break;
	case 1: //GM6
		addr=(IDirect3DDevice8**)5798500;
		GMD3DDev= *addr;
		break;
	default:
		return -1;
	}
	return 0;
}

GM_export double GMBULLET_SetD3DTransformMatrix(double ID)
{
	if(!GMD3DDev)
		return -2;
	btRigidBody* tb=gmbGlobal_RigidBodies.GetInstance(unsigned int(ID));
	if(!tb)
		return -3;
	btTransform tt;
	tb->getMotionState()->getWorldTransform(tt);
	btMatrix3x3 tm=tt.getBasis();
	btVector3 tv=tt.getOrigin();
	tv=tv*DistanceScale;
	tm=tm.transpose();
	
	D3DMATRIX matrix;
	matrix._11=tm[0].x();
	matrix._12=tm[0].y();
	matrix._13=tm[0].z();
	matrix._21=tm[1].x();
	matrix._22=tm[1].y();
	matrix._23=tm[1].z();
	matrix._31=tm[2].x();
	matrix._32=tm[2].y();
	matrix._33=tm[2].z();
	matrix._41=tv.x();
	matrix._42=tv.y();
	matrix._43=tv.z();
	matrix._44=1;
	matrix._34=0;
	matrix._24=0;
	matrix._14=0;
	
	GMD3DDev->SetTransform(D3DTS_WORLD,&matrix);
	return 0;
}
//
//GM_export double GMBULLET_

DebugDrawer* debugDraw=NULL;
GM_export double GMBULLET_SetupDebugDrawer()
{
	if(!gmbGlobal_World)
		return -1;
	if(debugDraw)
		return -2;
	debugDraw=new DebugDrawer();
	gmbGlobal_World->setDebugDrawer(debugDraw);
	return 0;
}
GM_export double GMBULLET_DebugDrawWorld()
{
	if(!gmbGlobal_World)
		return -1;
	gmbGlobal_World->debugDrawWorld();
	return 0;
}

#endif