/*
    GMaker - C/C++ Library to enable Game Maker functionality for DLLs.
    Copyright  2009 Preston N. Smith
*/

#include "GMaker.h"
#include <windows.h>

unsigned int __GMVersion = 0;

// Game Maker Variable

GMVariable::GMVariable()
{
  type = 0;
  real = 0;
  string = 0;
  padding = 0;
}

GMVariable::GMVariable(double a)
{
  type = 0;
  real = a;
  string = 0;
  padding = 0;
}

GMVariable::GMVariable(int a)
{
  type = 0;
  real = (double) a;
  string = 0;
  padding = 0;
}
GMVariable::GMVariable(unsigned int a)
{
  type = 0;
  real = (double) a;
  string = 0;
  padding = 0;
}

GMVariable::GMVariable(char* a)
{
  char* n;
  n = (char*) malloc(strlen(a) + 5);
  *((unsigned int*)n) = strlen(a);
  strcpy(n + 4, a);
  type = 1;
  real = 0;
  string = n + 4;
  padding = 0;
}

GMVariable::operator double()
{
  if(isReal()) return real;
  else return 0;
}

GMVariable::operator char*()
{
  if(isString()) return string;
  else return "";
}

double GMVariable::operator-(double a)
{
  real -= a;
  return real;
}

bool GMVariable::isReal()
{
  return (type == 0);
}

bool GMVariable::isString()
{
  return (type == 1);
}

namespace GM
{
  GMVariable ExternalCall(GMPROC* proc, int argsUsed, int argCount, GMVariable* args)
  {
	  GMVariable ret;
    if(argCount < 15) argsUsed = 0;
    DWORD t; t = (DWORD)&ret;
    __asm
    {
      //".intel_syntax noprefix\n"
      //"push %4\n"
        push (args);
      //"push %3\n"
        push (argCount);
      //"push %2\n"
        push (t);
      //"mov ecx, %1\n"
        mov ecx, (argsUsed);
      ///"call %0\n"
        call (proc)
      //".att_syntax\n"
      //:: "a" (proc), "b" (argsUsed), "c" (&ret), "d" (argCount), "r" (args)
    };
  
    return ret;
  }

  unsigned int GMVersion()
  {
    unsigned int ret = 0;
    void* versionPointer = (void*)((unsigned int) GetModuleHandle(NULL) + 0x0003A926);
    memcpy(&ret, versionPointer, 4);
    if(ret == 767) ret = 701;
    else if(ret == 601) ret = 601;
    else if(ret == 1515791364) ret = 600;
    else if(ret == -1962823152) ret = 503;
    return ret;
  }

  unsigned int GetProcTable(unsigned int v)
  {
    if(v == 701) return 0x189744;
    else if(v == 601) return 0x138550;
    else if(v == 600) return 0x123470;
    else if(v == 503) return 0x11CA24;
    else return 0;
  }

  void* GetProcAddress(char* procedure)
  {
    if(!__GMVersion) __GMVersion = GMVersion();
    char* address = (char*)((unsigned int) GetModuleHandle(NULL) + GetProcTable(__GMVersion));
    char* s; 
    address = (char*)*(void**) address;
    while(*address != 0)
    {
      s = address + 1;
      if(!strcmp(s, procedure)) break;
      address += 0x50;
    }
    if(*address == 0) return 0; 
    return (void*)*(unsigned int**)(address + 0x44);
  }

  bool SetProcAddress(char* procedure, void* newProcAddress)
  {
    if(!__GMVersion) __GMVersion = GMVersion();
    char* address = (char*)((unsigned int) GetModuleHandle(NULL) + GetProcTable(__GMVersion));
    char* s;
    address = (char*)*(void**) address;
    while(*address != 0)
    {
      s = address + 1;
      if(!strcmp(s, procedure)) break;
      address += 0x50;
    }
    if(*address == 0) return false; 
    *(unsigned int**)(address + 0x44) = (unsigned int*) newProcAddress;
    return true;
  }

  bool GetDebugMode()
  {
    HWND debug = FindWindowA(NULL, "Debug Information");
    return (IsWindowVisible(debug) && IsWindowEnabled(debug));
  }
}
