/*
    GMaker - C/C++ Library to enable Game Maker functionality for DLLs.
    Copyright  2009 Preston N. Smith
*/

#ifndef __GMAKER_H
#define __GMAKER_H

//#define export extern "C" __declspec(dllexport)

class GMVariable
{
private:
       int type;
       double real;
       char* string;
       int padding;
public:
       GMVariable();
       GMVariable(double a);
       GMVariable(int a);
	   GMVariable(unsigned int a);
       GMVariable(char* a);
       
       operator double();
       operator char*();
       double operator-(double a);
       
       bool isReal();
       bool isString();
};

typedef void GMPROC(GMVariable* ret, int argcount, GMVariable* args);

namespace GM
{
  unsigned int GMVersion();
  bool GetDebugMode();
  void* GetProcAddress(char* procedure);
  bool SetProcAddress(char* procedure, void* newProcAddress);
  GMVariable ExternalCall(GMPROC* proc, int argsUsed, int argCount, GMVariable* args);
}

#endif
