#include "GMaker.h"

using namespace GM;

GMPROC* pds_list_create=(GMPROC*)GetProcAddress("ds_list_create");
GMPROC* pds_list_destroy=(GMPROC*)GetProcAddress("ds_list_destroy");
GMPROC* pds_list_clear=(GMPROC*)GetProcAddress("ds_list_clear");
GMPROC* pds_list_copy=(GMPROC*)GetProcAddress("ds_list_copy");
GMPROC* pds_list_size=(GMPROC*)GetProcAddress("ds_list_size");
GMPROC* pds_list_empty=(GMPROC*)GetProcAddress("ds_list_empty");
GMPROC* pds_list_add=(GMPROC*)GetProcAddress("ds_list_add");
GMPROC* pds_list_insert=(GMPROC*)GetProcAddress("ds_list_insert");
GMPROC* pds_list_replace=(GMPROC*)GetProcAddress("ds_list_replace");
GMPROC* pds_list_delete=(GMPROC*)GetProcAddress("ds_list_delete");
GMPROC* pds_list_find_index=(GMPROC*)GetProcAddress("ds_list_find_index");
GMPROC* pds_list_find_value=(GMPROC*)GetProcAddress("ds_list_find_value");
GMPROC* pds_list_sort=(GMPROC*)GetProcAddress("ds_list_sort");
GMPROC* pds_list_shuffle=(GMPROC*)GetProcAddress("ds_list_shuffle");

double ds_list_create()
{
	return ExternalCall(pds_list_create, 0, 0, 0);
}
double ds_list_destroy(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_list_destroy, 1, 1, args);
}
double ds_list_clear(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_list_clear, 1, 1, args);
}
double ds_list_copy(double id,double source)
{
	GMVariable args[] = {id,source};
	return ExternalCall(pds_list_copy, 2, 2, args);
}
double ds_list_size(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_list_size, 1, 1, args);
}
double ds_list_empty(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_list_empty, 1, 1, args);
}
double ds_list_add(double id,GMVariable val)
{
	GMVariable args[] = {id,val};
	return ExternalCall(pds_list_add, 2, 2, args);
}
double ds_list_insert(double id,double pos,GMVariable val)
{
	GMVariable args[] = {id,pos,val};
	return ExternalCall(pds_list_insert, 3, 3, args);
}
double ds_list_replace(double id,double pos,GMVariable val)
{
	GMVariable args[] = {id,pos,val};
	return ExternalCall(pds_list_replace, 3, 3, args);
}
double ds_list_delete(double id,double pos)
{
	GMVariable args[] = {id,pos};
	return ExternalCall(pds_list_delete, 2, 2, args);
}
double ds_list_find_index(double id,GMVariable val)
{
	GMVariable args[] = {id,val};
	return ExternalCall(pds_list_find_index, 2, 2, args);
}
GMVariable ds_list_find_value(double id,double pos)
{
	GMVariable args[] = {id,pos};
	return ExternalCall(pds_list_find_value, 2, 2, args);
}
double ds_list_sort(double id,double ascend)
{
	GMVariable args[] = {id,ascend};
	return ExternalCall(pds_list_sort, 2, 2, args);
}
double ds_list_shuffle(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_list_shuffle, 1, 1, args);
}

//
GMPROC* pds_stack_create=(GMPROC*)GetProcAddress("ds_stack_create");
GMPROC* pds_stack_destroy=(GMPROC*)GetProcAddress("ds_stack_destroy");
GMPROC* pds_stack_clear=(GMPROC*)GetProcAddress("ds_stack_clear");
GMPROC* pds_stack_copy=(GMPROC*)GetProcAddress("ds_stack_copy");
GMPROC* pds_stack_size=(GMPROC*)GetProcAddress("ds_stack_size");
GMPROC* pds_stack_empty=(GMPROC*)GetProcAddress("ds_stack_empty");
GMPROC* pds_stack_push=(GMPROC*)GetProcAddress("ds_stack_push");
GMPROC* pds_stack_pop=(GMPROC*)GetProcAddress("ds_stack_pop");
GMPROC* pds_stack_top=(GMPROC*)GetProcAddress("ds_stack_top");

double ds_stack_create()
{
	return ExternalCall(pds_stack_create, 0,0,0);
}
double ds_stack_destroy(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_stack_destroy, 1, 1, args);
}
double ds_stack_clear(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_stack_clear, 1, 1, args);
}
double ds_stack_copy(double id,double source)
{
	GMVariable args[] = {id,source};
	return ExternalCall(pds_stack_copy, 2, 2, args);
}
double ds_stack_size(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_stack_size, 1, 1, args);
}
double ds_stack_empty(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_stack_empty, 1, 1, args);
}
double ds_stack_push(double id,GMVariable val)
{
	GMVariable args[] = {id,val};
	return ExternalCall(pds_stack_push, 2, 2, args);
}
GMVariable ds_stack_pop(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_stack_pop, 1, 1, args);
}
GMVariable ds_stack_top(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_stack_top, 1, 1, args);
}
//
GMPROC* pds_queue_create=(GMPROC*)GetProcAddress("ds_queue_create");
GMPROC* pds_queue_destroy=(GMPROC*)GetProcAddress("ds_queue_destroy");
GMPROC* pds_queue_clear=(GMPROC*)GetProcAddress("ds_queue_clear");
GMPROC* pds_queue_copy=(GMPROC*)GetProcAddress("ds_queue_copy");
GMPROC* pds_queue_size=(GMPROC*)GetProcAddress("ds_queue_size");
GMPROC* pds_queue_empty=(GMPROC*)GetProcAddress("ds_queue_empty");
GMPROC* pds_queue_enqueue=(GMPROC*)GetProcAddress("ds_queue_enqueue");
GMPROC* pds_queue_dequeue=(GMPROC*)GetProcAddress("ds_queue_dequeue");
GMPROC* pds_queue_head=(GMPROC*)GetProcAddress("ds_queue_head");
GMPROC* pds_queue_tail=(GMPROC*)GetProcAddress("ds_queue_tail");

double ds_queue_create()
{
	return ExternalCall(pds_queue_create, 0, 0, 0);
}
double ds_queue_destroy(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_queue_destroy, 1, 1, args);
}
double ds_queue_clear(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_queue_clear, 1, 1, args);
}
double ds_queue_copy(double id,double source)
{
	GMVariable args[] = {id,source};
	return ExternalCall(pds_queue_copy, 2, 2, args);
}
double ds_queue_size(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_queue_size, 1, 1, args);
}
double ds_queue_empty(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_queue_empty, 1, 1, args);
}
double ds_queue_enqueue(double id,GMVariable val)
{
	GMVariable args[] = {id,val};
	return ExternalCall(pds_queue_enqueue, 2, 2, args);
}
GMVariable ds_queue_dequeue(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_queue_dequeue, 1, 1, args);
}
GMVariable ds_queue_head(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_queue_head, 1, 1, args);
}
GMVariable ds_queue_tail(double id)
{
	GMVariable args[] = {id};
	return ExternalCall(pds_queue_tail, 1, 1, args);
}

GMPROC* pd3d_primitive_begin=(GMPROC*)GetProcAddress("d3d_primitive_begin");
GMPROC* pd3d_vertex_color=(GMPROC*)GetProcAddress("d3d_vertex_color");
GMPROC* pd3d_primitive_end=(GMPROC*)GetProcAddress("d3d_primitive_end");
GMPROC* pmake_color_rgb=(GMPROC*)GetProcAddress("make_color_rgb");

double d3d_primitive_begin(double numtri)
{
	GMVariable args[] = {numtri};
	return ExternalCall(pd3d_primitive_begin, 1, 1, args);
}
double d3d_vertex_color(double x,double y,double z,double col,double alpha)
{
	GMVariable args[] = {x,y,z,col,alpha};
	return ExternalCall(pd3d_vertex_color, 5, 5, args);
}
double d3d_primitive_end()
{
	return ExternalCall(pd3d_primitive_end, 0, 0, 0);
}
double make_color_rgb(double r,double b,double g)
{
	GMVariable args[] = {r,b,g};
	return ExternalCall(pmake_color_rgb, 3, 3, args);
}