
#define SXMS2_P_Init
dll = "SXMS2.dll" //Name of DLL to use

/*Pre-Initialize Functions (7)*/
global._SXMS2_P_SetBufferSize = external_define(dll,"SXMS2_P_SetBufferSize",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_P_SetDriver = external_define(dll,"SXMS2_P_SetDriver",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_P_SetHWND = external_define(dll,"SXMS2_P_SetHWND",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_P_SetMaxHardwareChannels = external_define(dll,"SXMS2_P_SetMaxHardwareChannels",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_P_SetMinHardwareChannels = external_define(dll,"SXMS2_P_SetMinHardwareChannels",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_P_SetMixer = external_define(dll,"SXMS2_P_SetMixer",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_P_SetOutput = external_define(dll,"SXMS2_P_SetOutput",dll_cdecl,ty_real,1,ty_real);
return 0;
/*The Arguments:
Return = NULL
*/

#define SXMS2_P_SetBufferSize
return external_call(global._SXMS2_P_SetBufferSize,argument0);
/*The Arguments:
Arg0 = REAL - The size of the buffer in milliseconds
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_P_SetDriver
return external_call(global._SXMS2_P_SetDriver,argument0);
/*The Arguments:
Arg0 = REAL - The number of the driver to use
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_P_SetHWND
return external_call(global._SXMS2_P_SetHWND,argument0);
/*The Arguments:
Arg0 = REAL - The handle of the control window
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_P_SetMaxHardwareChannels
return external_call(global._SXMS2_P_SetMaxHardwareChannels,argument0);
/*The Arguments:
Arg0 = REAL - The max number of allowed hardware channels
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_P_SetMinHardwareChannels
return external_call(global._SXMS2_P_SetMinHardwareChannels,argument0);
/*The Arguments:
Arg0 = REAL - The minimum number of hardware channels
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_P_SetMixer
return external_call(global._SXMS2_P_SetMixer,argument0);
/*The Arguments:
Arg0 = REAL - The type of mixer to use (0 to 2)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_P_SetOutput
return external_call(global._SXMS2_P_SetOutput,argument0);
/*The Arguments:
Arg0 = REAL - The type of output to use (0 to 5)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_I_Init
dll = "SXMS2.dll" //Name of DLL to use

/*Initialize Functions (2)*/
global._SXMS2_I_Init = external_define(dll,"SXMS2_I_Init",dll_cdecl,ty_real,7,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
global._SXMS2_I_Close = external_define(dll,"SXMS2_I_Close",dll_cdecl,ty_real,0);
/*Pre-Initialize Functions are initialized in SXMS2_P_Init()*/

/*Global Update Functions (4)*/
global._SXMS2_GU_SetPanSeperation = external_define(dll,"SXMS2_GU_SetPanSeperation",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_GU_SetSFXMasterVolume = external_define(dll,"SXMS2_GU_SetSFXMasterVolume",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_GU_SetSpeakerMode = external_define(dll,"SXMS2_GU_SetSpeakerMode",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_GU_Update = external_define(dll,"SXMS2_GU_Update",dll_cdecl,ty_real,0);

/*Global Information Functions (13)*/
global._SXMS2_GI_GetCPUUsage = external_define(dll,"SXMS2_GI_GetCPUUsage",dll_cdecl,ty_real,0);
global._SXMS2_GI_GetChannelsPlaying = external_define(dll,"SXMS2_GI_GetChannelsPlaying",dll_cdecl,ty_real,0);
global._SXMS2_GI_GetDriver = external_define(dll,"SXMS2_GI_GetDriver",dll_cdecl,ty_real,0);
global._SXMS2_GI_GetDriverName = external_define(dll,"SXMS2_GI_GetDriverName",dll_cdecl,ty_string,1,ty_real);
global._SXMS2_GI_GetMaxSamples = external_define(dll,"SXMS2_GI_GetMaxSamples",dll_cdecl,ty_real,0);
global._SXMS2_GI_GetMaxChannels = external_define(dll,"SXMS2_GI_GetMaxChannels",dll_cdecl,ty_real,0);
global._SXMS2_GI_GetMemoryStats = external_define(dll,"SXMS2_GI_GetMemoryStats",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_GI_GetNumDrivers = external_define(dll,"SXMS2_GI_GetNumDrivers",dll_cdecl,ty_real,0);
global._SXMS2_GI_GetNumHWChannels = external_define(dll,"SXMS2_GI_GetNumHWChannels",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_GI_GetOutput = external_define(dll,"SXMS2_GI_GetOutput",dll_cdecl,ty_real,0);
global._SXMS2_GI_GetOutputRate = external_define(dll,"SXMS2_GI_GetOutputRate",dll_cdecl,ty_real,0);
global._SXMS2_GI_GetSFXMasterVolume = external_define(dll,"SXMS2_GI_GetSFXMasterVolume",dll_cdecl,ty_real,0);
global._SXMS2_GI_GetVersion = external_define(dll,"SXMS2_GI_GetVersion",dll_cdecl,ty_real,0);

/*Sample Functions (13 - 1)*/
global._SXMS2_SA_Alloc = external_define(dll,"SXMS2_SA_Alloc",dll_cdecl,ty_real,10,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
global._SXMS2_SA_Free = external_define(dll,"SXMS2_SA_Free",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_SA_GetDefaults = external_define(dll,"SXMS2_SA_GetDefaults",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_SA_GetLength = external_define(dll,"SXMS2_SA_GetLength",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_SA_GetLoopPoints = external_define(dll,"SXMS2_SA_GetLoopPoints",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_SA_GetMinMaxDistance = external_define(dll,"SXMS2_SA_GetMinMaxDistance",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_SA_GetName = external_define(dll,"SXMS2_SA_GetName",dll_cdecl,ty_string,1,ty_real);
   /*These must work together*/
   global._SXMS2_SA_LoadName = external_define(dll,"SXMS2_SA_LoadName",dll_cdecl,ty_real,1,ty_string);
   global._SXMS2_SA_Load = external_define(dll,"SXMS2_SA_Load",dll_cdecl,ty_real,8,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
   /**/
global._SXMS2_SA_SetDefaults = external_define(dll,"SXMS2_SA_SetDefaults",dll_cdecl,ty_real,5,ty_real,ty_real,ty_real,ty_real,ty_real);
global._SXMS2_SA_SetMinMaxDistance = external_define(dll,"SXMS2_SA_SetMinMaxDistance",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
global._SXMS2_SA_SetMode = external_define(dll,"SXMS2_SA_SetMode",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_SA_SetLoopPoints = external_define(dll,"SXMS2_SA_SetLoopPoints",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);

/*Channel Functions (28)*/
global._SXMS2_C_PlaySoundEx = external_define(dll,"SXMS2_C_PlaySoundEx",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
global._SXMS2_C_StopSound = external_define(dll,"SXMS2_C_StopSound",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_C_SetFrequency = external_define(dll,"SXMS2_C_SetFrequency",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_C_SetLoopMode = external_define(dll,"SXMS2_C_SetLoopMode",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_C_SetMute = external_define(dll,"SXMS2_C_SetMute",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_C_SetPan = external_define(dll,"SXMS2_C_SetPan",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_C_SetPaused = external_define(dll,"SXMS2_C_SetPaused",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_C_SetPriority = external_define(dll,"SXMS2_C_SetPriority",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_C_SetReserved = external_define(dll,"SXMS2_C_SetReserved",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_C_SetSurround = external_define(dll,"SXMS2_C_SetSurround",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_C_SetVolume = external_define(dll,"SXMS2_C_SetVolume",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_C_SetVolumeAbsolute = external_define(dll,"SXMS2_C_SetVolumeAbsolute",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_C_GetVolume = external_define(dll,"SXMS2_C_GetVolume",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_C_3D_SetAttributes = external_define(dll,"SXMS2_C_3D_SetAttributes",dll_cdecl,ty_real,5,ty_real,ty_real,ty_real,ty_real,ty_real);
global._SXMS2_C_3D_SetMinMaxDistance = external_define(dll,"SXMS2_C_3D_SetMinMaxDistance",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
global._SXMS2_C_SetCurrentPosition = external_define(dll,"SXMS2_C_SetCurrentPosition",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_C_GetCurrentPosition = external_define(dll,"SXMS2_C_GetCurrentPosition",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_C_GetCurrentLevels = external_define(dll,"SXMS2_C_GetCurrentLevels",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_C_GetFrequency = external_define(dll,"SXMS2_C_GetFrequency",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_C_GetMute = external_define(dll,"SXMS2_C_GetMute",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_C_GetPan = external_define(dll,"SXMS2_C_GetPan",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_C_GetPaused = external_define(dll,"SXMS2_C_GetPaused",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_C_GetPriority = external_define(dll,"SXMS2_C_GetPriority",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_C_GetReserved = external_define(dll,"SXMS2_C_GetReserved",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_C_GetSurround = external_define(dll,"SXMS2_C_GetSurround",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_C_IsPlaying = external_define(dll,"SXMS2_C_IsPlaying",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_C_3D_GetAttributes = external_define(dll,"SXMS2_C_3D_GetAttributes",dll_cdecl,ty_string,2,ty_real,ty_real);
global._SXMS2_C_3D_GetMinMaxDistance = external_define(dll,"SXMS2_C_3D_GetMinMaxDistance",dll_cdecl,ty_real,2,ty_real,ty_real);

/*3D Functions (6)*/
global._SXMS2_3D_Listener_GetAttributes = external_define(dll,"SXMS2_3D_Listener_GetAttributes",dll_cdecl,ty_string,1,ty_real);
global._SXMS2_3D_Listener_SetAttributes = external_define(dll,"SXMS2_3D_Listener_SetAttributes",dll_cdecl,ty_real,10,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
global._SXMS2_3D_Listener_SetCurrent = external_define(dll,"SXMS2_3D_Listener_SetCurrent",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_3D_SetDistanceFactor = external_define(dll,"SXMS2_3D_SetDistanceFactor",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_3D_SetDopplerFactor = external_define(dll,"SXMS2_3D_SetDopplerFactor",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_3D_SetRolloffFactor = external_define(dll,"SXMS2_3D_SetRolloffFactor",dll_cdecl,ty_real,1,ty_real);

/*Stream Functions (24 - 1)*/
global._SXMS2_ST_Close = external_define(dll,"SXMS2_ST_Close",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_ST_GetLength = external_define(dll,"SXMS2_ST_GetLength",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_ST_GetLengthMs = external_define(dll,"SXMS2_ST_GetLengthMs",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_ST_GetNumSubStreams = external_define(dll,"SXMS2_ST_GetNumSubStreams",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_ST_GetNumTagFields = external_define(dll,"SXMS2_ST_GetNumTagFields",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_ST_GetOpenState = external_define(dll,"SXMS2_ST_GetOpenState",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_ST_GetPosition = external_define(dll,"SXMS2_ST_GetPosition",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_ST_GetTagField = external_define(dll,"SXMS2_ST_GetTagField",dll_cdecl,ty_string,3,ty_real,ty_real,ty_real);
global._SXMS2_ST_GetTime = external_define(dll,"SXMS2_ST_GetTime",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_ST_Net_GetBufferProperties = external_define(dll,"SXMS2_ST_Net_GetBufferProperties",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_ST_Net_GetLastServerStatus = external_define(dll,"SXMS2_ST_Net_GetLastServerStatus",dll_cdecl,ty_string,0);
global._SXMS2_ST_Net_GetStatus = external_define(dll,"SXMS2_ST_Net_GetStatus",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_ST_Net_SetBufferProperties = external_define(dll,"SXMS2_ST_Net_SetBufferProperties",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
global._SXMS2_ST_Net_SetProxy = external_define(dll,"SXMS2_ST_Net_SetProxy",dll_cdecl,ty_real,1,ty_string);
   /*These must work together*/
   global._SXMS2_ST_OpenName = external_define(dll,"SXMS2_ST_OpenName",dll_cdecl,ty_real,1,ty_string);
   global._SXMS2_ST_Open = external_define(dll,"SXMS2_ST_Open",dll_cdecl,ty_real,8,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
   /**/
global._SXMS2_ST_Play = external_define(dll,"SXMS2_ST_Play",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_ST_SetBufferSize = external_define(dll,"SXMS2_ST_SetBufferSize",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_ST_SetLoopCount = external_define(dll,"SXMS2_ST_SetLoopCount",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_ST_SetLoopPoints = external_define(dll,"SXMS2_ST_SetLoopPoints",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
global._SXMS2_ST_SetPosition = external_define(dll,"SXMS2_ST_SetPosition",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_ST_SetSubStream = external_define(dll,"SXMS2_ST_SetSubStream",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_ST_SetTime = external_define(dll,"SXMS2_ST_SetTime",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_ST_Stop = external_define(dll,"SXMS2_ST_Stop",dll_cdecl,ty_real,1,ty_real);

/*Compact Disk Functions (12)*/
global._SXMS2_CD_OpenTray = external_define(dll,"SXMS2_CD_OpenTray",dll_cdecl,ty_real,2,ty_string,ty_real);
global._SXMS2_CD_GetNumTracks = external_define(dll,"SXMS2_CD_GetNumTracks",dll_cdecl,ty_real,1,ty_string);
global._SXMS2_CD_GetPaused = external_define(dll,"SXMS2_CD_GetPaused",dll_cdecl,ty_real,1,ty_string);
global._SXMS2_CD_GetTrack = external_define(dll,"SXMS2_CD_GetTrack",dll_cdecl,ty_real,1,ty_string);
global._SXMS2_CD_GetTrackLength = external_define(dll,"SXMS2_CD_GetTrackLength",dll_cdecl,ty_real,2,ty_string,ty_real);
global._SXMS2_CD_GetTrackTime = external_define(dll,"SXMS2_CD_GetTrackTime",dll_cdecl,ty_real,1,ty_string);
global._SXMS2_CD_Play = external_define(dll,"SXMS2_CD_Play",dll_cdecl,ty_real,2,ty_string,ty_real);
global._SXMS2_CD_SetPaused = external_define(dll,"SXMS2_CD_SetPaused",dll_cdecl,ty_real,2,ty_string,ty_real);
global._SXMS2_CD_SetPlayMode = external_define(dll,"SXMS2_CD_SetPlayMode",dll_cdecl,ty_real,2,ty_string,ty_real);
global._SXMS2_CD_SetTrackTime = external_define(dll,"SXMS2_CD_SetTrackTime",dll_cdecl,ty_real,2,ty_string,ty_real);
global._SXMS2_CD_SetVolume = external_define(dll,"SXMS2_CD_SetVolume",dll_cdecl,ty_real,2,ty_string,ty_real);
global._SXMS2_CD_Stop = external_define(dll,"SXMS2_CD_Stop",dll_cdecl,ty_real,1,ty_string);

/*DSP Functions (7)*/
global._SXMS2_DSP_ClearMixBuffer = external_define(dll,"SXMS2_DSP_ClearMixBuffer",dll_cdecl,ty_real,0);
global._SXMS2_DSP_SetActive = external_define(dll,"SXMS2_DSP_SetActive",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_DSP_GetActive = external_define(dll,"SXMS2_DSP_GetActive",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_DSP_GetBufferLengthTotal = external_define(dll,"SXMS2_DSP_GetBufferLengthTotal",dll_cdecl,ty_real,0);
global._SXMS2_DSP_SetPriority = external_define(dll,"SXMS2_DSP_SetPriority",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_DSP_GetPriority = external_define(dll,"SXMS2_DSP_GetPriority",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_DSP_GetSpectrum = external_define(dll,"SXMS2_DSP_GetSpectrum",dll_cdecl,ty_real,1,ty_real);

/*DirectX 8.1 FX Functions (12)*/
global._SXMS2_FX_Disable = external_define(dll,"SXMS2_FX_Disable",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_FX_Enable = external_define(dll,"SXMS2_FX_Enable",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_FX_SetChorus = external_define(dll,"SXMS2_FX_SetChorus",dll_cdecl,ty_real,8,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
global._SXMS2_FX_SetCompressor = external_define(dll,"SXMS2_FX_SetCompressor",dll_cdecl,ty_real,7,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
global._SXMS2_FX_SetDistortion = external_define(dll,"SXMS2_FX_SetDistortion",dll_cdecl,ty_real,6,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
global._SXMS2_FX_SetEcho = external_define(dll,"SXMS2_FX_SetEcho",dll_cdecl,ty_real,6,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
global._SXMS2_FX_SetFlanger = external_define(dll,"SXMS2_FX_SetFlanger",dll_cdecl,ty_real,8,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
global._SXMS2_FX_SetGargle = external_define(dll,"SXMS2_FX_SetGargle",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
   /*These must work together*/
   global._SXMS2_FX_SetI3DL2Reverb1 = external_define(dll,"SXMS2_FX_SetI3DL2Reverb1",dll_cdecl,ty_real,4,ty_real,ty_real,ty_real,ty_real);
   global._SXMS2_FX_SetI3DL2Reverb2 = external_define(dll,"SXMS2_FX_SetI3DL2Reverb2",dll_cdecl,ty_real,9,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real,ty_real);
   /**/
global._SXMS2_FX_SetParamEQ = external_define(dll,"SXMS2_FX_SetParamEQ",dll_cdecl,ty_real,4,ty_real,ty_real,ty_real,ty_real);
global._SXMS2_FX_SetWavesReverb = external_define(dll,"SXMS2_FX_SetWavesReverb",dll_cdecl,ty_real,5,ty_real,ty_real,ty_real,ty_real,ty_real);

/*Recording Functions (7)*/
global._SXMS2_R_GetDriver = external_define(dll,"SXMS2_R_GetDriver",dll_cdecl,ty_real,0);
global._SXMS2_R_GetDriverName = external_define(dll,"SXMS2_R_GetDriverName",dll_cdecl,ty_string,1,ty_real);
global._SXMS2_R_GetNumDrivers = external_define(dll,"SXMS2_R_GetNumDrivers",dll_cdecl,ty_real,0);
global._SXMS2_R_GetPosition = external_define(dll,"SXMS2_R_GetPosition",dll_cdecl,ty_real,0);
global._SXMS2_R_SetDriver = external_define(dll,"SXMS2_R_SetDriver",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_R_StartSample = external_define(dll,"SXMS2_R_StartSample",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_R_Stop = external_define(dll,"SXMS2_R_Stop",dll_cdecl,ty_real,0);

/*FMUSIC Control Functions (15)*/
global._SXMS2_MC_FreeSong = external_define(dll,"SXMS2_MC_FreeSong",dll_cdecl,ty_real,1,ty_real);
   /*These must work together*/
   global._SXMS2_MC_LoadSongExName = external_define(dll,"SXMS2_MC_LoadSongExName",dll_cdecl,ty_real,1,ty_string);
   global._SXMS2_MC_LoadSongEx = external_define(dll,"SXMS2_MC_LoadSongEx",dll_cdecl,ty_real,5,ty_real,ty_real,ty_real,ty_real,ty_real);
   /**/
global._SXMS2_MC_OptimizeChannels = external_define(dll,"SXMS2_MC_OptimizeChannels",dll_cdecl,ty_real,3,ty_real,ty_real,ty_real);
global._SXMS2_MC_PlaySong = external_define(dll,"SXMS2_MC_PlaySong",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MC_SetLooping = external_define(dll,"SXMS2_MC_SetLooping",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_MC_SetMasterSpeed = external_define(dll,"SXMS2_MC_SetMasterSpeed",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_MC_SetMasterVolume = external_define(dll,"SXMS2_MC_SetMasterVolume",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_MC_SetOrder = external_define(dll,"SXMS2_MC_SetOrder",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_MC_SetPanSeperation = external_define(dll,"SXMS2_MC_SetPanSeperation",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_MC_SetPaused = external_define(dll,"SXMS2_MC_SetPaused",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_MC_SetReverb = external_define(dll,"SXMS2_MC_SetReverb",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MC_SetSample = external_define(dll,"SXMS2_MC_SetSample",dll_cdecl,ty_real,3,ty_string,ty_real,ty_real);
global._SXMS2_MC_StopAllSongs = external_define(dll,"SXMS2_MC_StopAllSongs",dll_cdecl,ty_real,0);
global._SXMS2_MC_StopSong = external_define(dll,"SXMS2_MC_StopSong",dll_cdecl,ty_real,1,ty_real);

/*FMUSIC Information Functions (21)*/
global._SXMS2_MI_GetBPM = external_define(dll,"SXMS2_MI_GetBPM",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetGlobalVolume = external_define(dll,"SXMS2_MI_GetGlobalVolume",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetMasterVolume = external_define(dll,"SXMS2_MI_GetMasterVolume",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetName = external_define(dll,"SXMS2_MI_GetName",dll_cdecl,ty_string,1,ty_real);
global._SXMS2_MI_GetNumChannels = external_define(dll,"SXMS2_MI_GetNumChannels",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetNumInstruments = external_define(dll,"SXMS2_MI_GetNumInstruments",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetNumOrders = external_define(dll,"SXMS2_MI_GetNumOrders",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetNumPatterns = external_define(dll,"SXMS2_MI_GetNumPatterns",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetNumSamples = external_define(dll,"SXMS2_MI_GetNumSamples",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetOpenState = external_define(dll,"SXMS2_MI_GetOpenState",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetOrder = external_define(dll,"SXMS2_MI_GetOrder",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetPattern = external_define(dll,"SXMS2_MI_GetPattern",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetPatternLength = external_define(dll,"SXMS2_MI_GetPatternLength",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_MI_GetPaused = external_define(dll,"SXMS2_MI_GetPaused",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetRealChannel = external_define(dll,"SXMS2_MI_GetRealChannel",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_MI_GetRow = external_define(dll,"SXMS2_MI_GetRow",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_ExportSample = external_define(dll,"SXMS2_MI_ExportSample",dll_cdecl,ty_real,3,ty_string,ty_real,ty_real);
global._SXMS2_MI_GetSpeed = external_define(dll,"SXMS2_MI_GetSpeed",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_GetTime = external_define(dll,"SXMS2_MI_GetTime",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_IsFinished = external_define(dll,"SXMS2_MI_IsFinished",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_MI_IsPlaying = external_define(dll,"SXMS2_MI_IsPlaying",dll_cdecl,ty_real,1,ty_real);

/*WinAmp Plugin Support Functions are initialized in SXMS2_W_Init()*/

/*Shaltif's Additional Functions (4)*/
global._SXMS2_S_BitRate = external_define(dll,"SXMS2_S_BitRate",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_S_ModRows = external_define(dll,"SXMS2_S_ModRows",dll_cdecl,ty_real,2,ty_real,ty_real);
global._SXMS2_S_PercentComplete = external_define(dll,"SXMS2_S_PercentComplete",dll_cdecl,ty_real,4,ty_real,ty_real,ty_real,ty_string);
global._SXMS2_S_SaveToWav = external_define(dll,"SXMS2_S_SaveToWav",dll_cdecl,ty_real,2,ty_string,ty_real);

/*The actual initalizing of the fmod.dll*/
return external_call(global._SXMS2_I_Init,argument0,argument1,argument2,argument3,argument4,argument5,argument6);
/*The Arguments:
Arg0 = REAL - Mix Rate in Hz (4000 to 65535)
Arg1 = REAL - Max Initialized Software Channels (0 to 1024)
Arg2 = REAL - Use Default Midi Synth (TRUE or FALSE)
Arg3 = REAL - Use Global Focus (TRUE or FALSE)
Arg4 = REAL - Enable System Channel FX (TRUE or FALSE)
Arg5 = REAL - Accurate VU Levels (TRUE or FALSE)
Arg6 = REAL - Don't Latancy Adjust Return Information (TRUE or FALSE)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_I_Close
return external_call(global._SXMS2_I_Close);
/*The Arguments:
Return = NULL
*/

#define SXMS2_GU_SetPanSeperation
return external_call(global._SXMS2_GU_SetPanSeperation,argument0);
/*The Arguments:
Arg0 = REAL - The scale of stereo pan.  (0.0 to 1.0)
Return = NULL
*/

#define SXMS2_GU_SetSFXMasterVolume
return external_call(global._SXMS2_GU_SetSFXMasterVolume,argument0);
/*The Arguments:
Arg0 = REAL - The master volume for all SFX  (0 to 255)
Return = NULL
*/

#define SXMS2_GU_SetSpeakerMode
return external_call(global._SXMS2_GU_SetSpeakerMode,argument0);
/*The Arguments:
Arg0 = REAL - The type of speaker setup to use (0 to 5)
Return = NULL
*/

#define SXMS2_GU_Update
return external_call(global._SXMS2_GU_Update);
/*The Arguments:
Return = NULL
*/

#define SXMS2_GI_GetCPUUsage
return external_call(global._SXMS2_GI_GetCPUUsage);
/*The Arguments:
Return = REAL - Amount of cpu usage by fmod (0.00 to 100.00)
*/

#define SXMS2_GI_GetChannelsPlaying
return external_call(global._SXMS2_GI_GetChannelsPlaying);
/*The Arguments:
Return = REAL - Number of active channels
*/

#define SXMS2_GI_GetDriver
return external_call(global._SXMS2_GI_GetDriver);
/*The Arguments:
Return = REAL - Current driver ID number
*/

#define SXMS2_GI_GetDriverName
return external_call(global._SXMS2_GI_GetDriverName,argument0);
/*The Arguments:
Arg0 = REAL - The ID number of the driver
Return = STRING - Name of the driver
*/

#define SXMS2_GI_GetMaxSamples
return external_call(global._SXMS2_GI_GetMaxSamples);
/*The Arguments:
Return = REAL - The max sample index
*/

#define SXMS2_GI_GetMemoryStats
return external_call(global._SXMS2_GI_GetMemoryStats,argument0);
/*The Arguments:
Arg0 = REAL - The type of information to return (0 or 1)
Return = REAL - Current used memory or the max available memory
*/

#define SXMS2_GI_GetNumDrivers
return external_call(global._SXMS2_GI_GetNumDrivers);
/*The Arguments:
Return = REAL - The number of available drivers
*/

#define SXMS2_GI_GetNumHWChannels
return external_call(global._SXMS2_GI_GetNumHWChannels,argument0);
/*The Arguments:
Arg0 = REAL - The type of information to return (0 to 2)
Return = REAL - 

(Depending on Argument0)
0: Total available hardware channels (2D + 3D)
1: Available 2D hardware mixed channels
2: Available 3D hardware mixed channels
*/

#define SXMS2_GI_GetOutput
return external_call(global._SXMS2_GI_GetOutput);
/*The Arguments:
Return = REAL - The ID of the output type
*/

#define SXMS2_GI_GetOutputRate
return external_call(global._SXMS2_GI_GetOutputRate);
/*The Arguments:
Return = REAL - Current output rate in Hz
*/

#define SXMS2_GI_GetSFXMasterVolume
return external_call(global._SXMS2_GI_GetSFXMasterVolume);
/*The Arguments:
Return = REAL - The current SFX master volume (0 to 255)
*/

#define SXMS2_GI_GetVersion
return external_call(global._SXMS2_GI_GetVersion);
/*The Arguments:
Return = REAL - The version of fmod being used
(These scripts were designed to use fmod version 3.72)
*/

#define SXMS2_SA_Alloc
return external_call(global._SXMS2_SA_Alloc,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7,argument8,argument9);
/*The Arguments:
Arg0 = REAL - The index ID to create the sample in
Arg1 = REAL - Length of the sample buffer in SAMPLES
Arg2 = REAL - The default frequency (4000 to 65535) (-1 to ignore)
Arg3 = REAL - The default volume (0 to 255) (-1 to ignore)
Arg4 = REAL - The default panning (0 to 255) (-1 for special STEREO PAN)
Arg5 = REAL - The default priority (0 to 255) (-1 to ignore)
Arg6 = REAL - The looping mode (0 to 2)
Arg7 = REAL - Mono or Stereo Sample (1 or 2) (0 to ignore)
Arg8 = REAL - 8Bit or 16Bit Sample (1 or 2) (0 to ignore)
Arg9 = REAL - Enable FX functions (0 or 1)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_SA_Free
return external_call(global._SXMS2_SA_Free,argument0);
/*The Arguments:
Arg0 = REAL - The index ID of the sample to remove
Return = NULL
*/

#define SXMS2_SA_GetDefaults
return external_call(global._SXMS2_SA_GetDefaults,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The index ID of the sample
Arg1 = REAL - The type of information to return (0 to 3)
Return = REAL - 

(Depending on argument1)
0: Default frequency
1: Default volume
2: Default panning
3: Default priority
*/

#define SXMS2_SA_GetLength
return external_call(global._SXMS2_SA_GetLength,argument0);
/*The Arguments:
Arg0 = REAL - The index ID of the sample
Return = REAL - The length of the sample in SAMPLES
*/

#define SXMS2_SA_GetLoopPoints
return external_call(global._SXMS2_SA_GetLoopPoints,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The index ID of the sample
Arg1 = REAL - The type of information to return (0 or 1)
Return = REAL -

(Depending on argument1)
0: The loop end point
1: The loop start point
*/

#define SXMS2_SA_GetMinMaxDistance
return external_call(global._SXMS2_SA_GetMinMaxDistance,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The index ID of the sample
Arg1 = REAL - The type of information to return (0 or 1)
Return = REAL -

(Depending on argument1)
0: The maximum distance
1: The minimum distance
*/

#define SXMS2_SA_GetName
return external_call(global._SXMS2_SA_GetName,argument0);
/*The Arguments:
Arg0 = REAL - The index ID of the sample
Return = STRING - The name of the sample
*/

#define SXMS2_SA_Load
external_call(global._SXMS2_SA_LoadName,argument0); //Loads in the name
return external_call(global._SXMS2_SA_Load,argument1,argument2,argument3,argument4,argument5,argument6,argument7,argument8);
/*The Arguments:
Arg0 = STRING - The name of the file to load
Arg1 = REAL - The index ID to store the loaded sample
Arg2 = REAL - The seek offset value (optional) (greater than 0 to set)
Arg3 = REAL - The length of the sample (only use if Arg2 is used)
Arg4 = REAL - The looping mode (0 to 2)
Arg5 = REAL - Mono or Stereo (1 or 2) (0 to ignore)
Arg6 = REAL - 8Bit or 16Bit (1 or 2) (0 to ignore)
Arg7 = REAL - Enable FX effects (0 or 1)
Arg8 = REAL - Whether to load into 2D Hardware (1), 3D Hardware (2) or not (0)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_SA_SetDefaults
return external_call(global._SXMS2_SA_SetDefaults,argument0,argument1,argument2,argument3,argument4);
/*The Arguments:
Arg0 = REAL - The index ID of the sample
Arg1 = REAL - The default frequency (4000 to 65535) (-1 to ignore)
Arg2 = REAL - The default volume (0 to 255) (-1 to ignore)
Arg3 = REAL - The default panning (0 to 255) (-1 for special STEREO PAN)
Arg4 = REAL - The default priority (0 to 255) (-1 to ignore)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_SA_SetMinMaxDistance
return external_call(global._SXMS2_SA_SetMinMaxDistance,argument0,argument1,argument2);
/*The Arguments:
Arg0 = REAL - The index ID of the sample
Arg1 = REAL - The minimum distance
Arg2 = REAL - The maximum distance
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_SA_SetMode
return external_call(global._SXMS2_SA_SetMode,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The index ID of the sample
Arg1 = REAL - The mode to set (0 to 3)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_SA_SetLoopPoints
return external_call(global._SXMS2_SA_SetLoopPoints,argument0,argument1,argument2);
/*The Arguments:
Arg0 = REAL - The index ID of the sample
Arg1 = REAL - The start loop point (in SAMPLES)
Arg2 = REAL - The end loop point (in SAMPLES)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_PlaySoundEx
return external_call(global._SXMS2_C_PlaySoundEx,argument0,argument1,argument2);
/*The Arguments:
Arg0 = REAL - The channel to play in
Arg1 = REAL - The sample index ID to play
Arg2 = REAL - Whether to start paused (0 or 1)
Return = REAL - Successful, Channel handle (>0) or Failed (-1)
*/

#define SXMS2_C_StopSound
return external_call(global._SXMS2_C_StopSound,argument0);
/*The Arguments:
Arg0 = REAL - The channel to stop playback
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_SetFrequency
return external_call(global._SXMS2_C_SetFrequency,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to effect
Arg1 = REAL - The frequency (100 to 705600 or -100 to -705600)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_SetLoopMode
return external_call(global._SXMS2_C_SetLoopMode,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to effect
Arg1 = REAL - The loop mode (0 to 2)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_SetMute
return external_call(global._SXMS2_C_SetMute,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to effect
Arg1 = REAL - Whether to Mute (0 or 1)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_SetPan
return external_call(global._SXMS2_C_SetPan,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to effect
Arg1 = REAL - The panning (0 to 255) (-1 for special STEREO PAN)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_SetPaused
return external_call(global._SXMS2_C_SetPaused,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to effect
Arg1 = REAL - Whether to pause (0 or 1)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_SetPriority
return external_call(global._SXMS2_C_SetPriority,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to effect
Arg1 = REAL - The priority setting (0 to 255)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_SetReserved
return external_call(global._SXMS2_C_SetReserved,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to effect
Arg1 = REAL - Whether to reserve (0 or 1)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_SetSurround
return external_call(global._SXMS2_C_SetSurround,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to effect
Arg1 = REAL - Whether to set surround (0 or 1)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_SetVolume
return external_call(global._SXMS2_C_SetVolume,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to effect
Arg1 = REAL - The volume (0 to 255)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_SetVolumeAbsolute
return external_call(global._SXMS2_C_SetVolumeAbsolute,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to effect
Arg1 = REAL - The volume (0 to 255)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_GetVolume
return external_call(global._SXMS2_C_GetVolume,argument0);
/*The Arguments:
Arg0 = REAL - The channel to get volume of
Return = REAL - The volume of the channel (0 to 255)
*/

#define SXMS2_C_3D_SetAttributes
return external_call(global._SXMS2_C_3D_SetAttributes,argument0,argument1,argument2,argument3,argument4);
/*The Arguments:
Arg0 = REAL - The channel to set
Arg1 = REAL - Whether the XYZ Triplet is for position (0) or velocity (1)
Arg2 = REAL - X component of Triplet
Arg3 = REAL - Y component of Triplet
Arg4 = REAL - Z compenent of Triplet
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_3D_SetMinMaxDistance
return external_call(global._SXMS2_C_3D_SetMinMaxDistance,argument0,argument1,argument2);
/*The Arguments:
Arg0 = REAL - The channel to set
Arg1 = REAL - The Minimum
Arg2 = REAL - The Maximum
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_SetCurrentPosition
return external_call(global._SXMS2_C_SetCurrentPosition,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to set position
Arg1 = REAL - The position to jump to in SAMPLES
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_C_GetCurrentPosition
return external_call(global._SXMS2_C_GetCurrentPosition,argument0);
/*The Arguments:
Arg0 = REAL - The channel to get the position
Return = REAL - The current position in SAMPLES
*/

#define SXMS2_C_GetCurrentLevels
return external_call(global._SXMS2_C_GetCurrentLevels,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to get the left/right levels from
Arg1 = REAL - The type of information to return
Return = REAL -

(Depends on argument1)
0: left audio level
1: right audio level
*/

#define SXMS2_C_GetFrequency
return external_call(global._SXMS2_C_GetFrequency,argument0);
/*The Arguments:
Arg0 = REAL - The channel to get the frequency
Return = REAL - The frequency of the channel
*/

#define SXMS2_C_GetMute
return external_call(global._SXMS2_C_GetMute,argument0);
/*The Arguments:
Arg0 = REAL - The channel to get mute info
Return = REAL - Whether muted (1) or not (0)
*/

#define SXMS2_C_GetPan
return external_call(global._SXMS2_C_GetPan,argument0);
/*The Arguments:
Arg0 = REAL - The channel to get panning
Return = REAL - The panning (0 to 255) (-1 if STEREO PAN)
*/

#define SXMS2_C_GetPaused
return external_call(global._SXMS2_C_GetPaused,argument0);
/*The Arguments:
Arg0 = REAL - The channel to get paused
Return = REAL - Whether paused (1) or not (0)
*/

#define SXMS2_C_GetPriority
return external_call(global._SXMS2_C_GetPriority,argument0);
/*The Arguments:
Arg0 = REAL - The channel to get priority
Return = REAL - The priority of the channel (0 to 255) (256 if Stream)
*/

#define SXMS2_C_GetReserved
return external_call(global._SXMS2_C_GetReserved,argument0);
/*The Arguments:
Arg0 = REAL - The channel to get reserved
Return = REAL - Whether reserved (1) or not (0)
*/

#define SXMS2_C_GetSurround
return external_call(global._SXMS2_C_GetSurround,argument0);
/*The Arguments:
Arg0 = REAL - The channel to get surround
Return = REAL - Whether surround (1) or not (0)
*/

#define SXMS2_C_IsPlaying
return external_call(global._SXMS2_C_IsPlaying,argument0);
/*The Arguments:
Arg0 = REAL - The channel to get if playing
Return = REAL - Whether playing (1) or not (0)
*/

#define SXMS2_C_3D_GetAttributes
return external_call(global._SXMS2_C_3D_GetAttributes,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to get 3D Attributes
Arg1 = REAL - Whether to return position (0) or velocity (1) vector
Return = STRING - The XYZ triplet as a string

Example Return = "X|Y|Z" or "1.3|4.5|0.4"
*/

#define SXMS2_C_3D_GetMinMaxDistance
return external_call(global._SXMS2_C_3D_GetMinMaxDistance,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to get 3D MinMaxDistance
Arg1 = REAL - Whether to return minimum (0) or maximum (1)
Return = REAL - The minimum or maximum information
*/

#define SXMS2_3D_Listener_GetAttributes
return external_call(global._SXMS2_3D_Listener_GetAttributes,argument0);
/*The Arguments:
Arg0 = REAL - The type of returned information (0 or 1)
Return = STRING - XYZ triplet, XYZ of forward unit length, XYZ of top unit length

(Depending on argument0)
0: Position Vector
1: Velocity Vector

Example Return = "X|Y|Z|FX|FY|FZ|TX|TY|TZ"
The first set (XYZ) is either the position or velocity
*/

#define SXMS2_3D_Listener_SetAttributes
return external_call(global._SXMS2_3D_Listener_SetAttributes,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7,argument8,argument9);
/*The Arguments:
Arg0 = REAL - Whether the XYZ Triplet is Position (0) or velocity (1)
Arg1 = REAL - X componet of triplet
Arg2 = REAL - Y componet of triplet
Arg3 = REAL - Z componet of triplet
Arg4 = REAL - X Forward unit length
Arg5 = REAL - Y Forward unit length
Arg6 = REAL - Z Forward unit length
Arg7 = REAL - X Top facing unit length
Arg8 = REAL - Y Top facing unit length
Arg9 = REAL - Z Top facing unit length
Return = NULL
*/

#define SXMS2_3D_Listener_SetCurrent
return external_call(global._SXMS2_3D_Listener_SetCurrent,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The current listener (default 0)
Arg1 = REAL - Total number of active listeners
Return = NULL
*/

#define SXMS2_3D_SetDistanceFactor
return external_call(global._SXMS2_3D_SetDistanceFactor,argument0);
/*The Arguments:
Arg0 = REAL - The distance (in meters) 1.0 meters = 3.28 feet
Return = NULL
*/

#define SXMS2_3D_SetDopplerFactor
return external_call(global._SXMS2_3D_SetDopplerFactor,argument0);
/*The Arguments:
Arg0 = REAL - The doppler scale.  Default = 1.0
Return = NULL
*/

#define SXMS2_3D_SetRolloffFactor
return external_call(global._SXMS2_3D_SetRolloffFactor,argument0);
/*The Arguments:
Arg0 = REAL - The rolloff factor (0 to 10)
Return = NULL
*/

#define SXMS2_ST_Close
return external_call(global._SXMS2_ST_Close,argument0);
/*The Arguments:
Arg0 = REAL - The index of the stream
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_ST_GetLength
return external_call(global._SXMS2_ST_GetLength,argument0);
/*The Arguments:
Arg0 = REAL - The index of the stream
Return = REAL - The length (in bytes) of the stream.
*/

#define SXMS2_ST_GetLengthMs
return external_call(global._SXMS2_ST_GetLengthMs,argument0);
/*The Arguments:
Arg0 = REAL - The index of the stream
Return = REAL - The length (in milliseconds) of the stream.
*/

#define SXMS2_ST_GetNumSubStreams
return external_call(global._SXMS2_ST_GetNumSubStreams,argument0);
/*The Arguments:
Arg0 = REAL - The index of the loaded stream
Return = REAL - The number of sub streams
*/

#define SXMS2_ST_GetNumTagFields
return external_call(global._SXMS2_ST_GetNumTagFields,argument0);
/*The Arguments:
Arg0 = REAL - The index of the loaded stream
Return = REAL - The number of Tags
*/

#define SXMS2_ST_GetOpenState
return external_call(global._SXMS2_ST_GetOpenState,argument0);
/*The Arguments:
Arg0 = REAL - The index of the loaded stream
Return = REAL - The state of the opened file (-5 to 0)
*/

#define SXMS2_ST_GetPosition
return external_call(global._SXMS2_ST_GetPosition,argument0);
/*The Arguments:
Arg0 = REAL - The index of the loaded stream
Return = REAL - The current position (in bytes)
*/

#define SXMS2_ST_GetTagField
return external_call(global._SXMS2_ST_GetTagField,argument0,argument1,argument2);
/*The Arguments:
Arg0 = REAL - The tag to read
Arg1 = REAL - The type of information to return
Arg2 = REAL - The index of a loaded stream
Return = STRING -

(Depending on argument1)
0: Type of Tag
1: Title of Tag
2: Value in Tag
3: Size of Tag in Bytes
*/

#define SXMS2_ST_GetTime
return external_call(global._SXMS2_ST_GetTime,argument0);
/*The Arguments:
Arg0 = REAL - The index of a loaded stream
Return = REAL - The current position (in milliseconds)
*/

#define SXMS2_ST_Net_GetBufferProperties
return external_call(global._SXMS2_ST_Net_GetBufferProperties,argument0);
/*The Arguments:
Arg0 = REAL - The type of return value (0 - 2)
Return = REAL -

(Depends on argument0)
0: Buffersize
1: Pre-Buffer Percent
2: Re-Buffer Percent
*/

#define SXMS2_ST_Net_GetLastServerStatus
return external_call(global._SXMS2_ST_Net_GetLastServerStatus);
/*The Arguments:
Return = STRING - The last HTTP status line received
*/

#define SXMS2_ST_Net_GetStatus
return external_call(global._SXMS2_ST_Net_GetStatus,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The type of information returned (0 to 3)
Arg1 = REAL - The index to a loaded stream
Return = REAL -

(Depends on argument0)
0: The status (0 to 4)
1: The amount of buffer used
2: The bitrate
3: The protocol used (0 to 4)
*/

#define SXMS2_ST_Net_SetBufferProperties
return external_call(global._SXMS2_ST_Net_SetBufferProperties,argument0,argument1,argument2);
/*The Arguments:
Arg0 = REAL - The buffersize (in bytes)
Arg1 = REAL - The Pre-buffer percent (1 to 99)
Arg2 = REAL - The Re-buffer percent (1 to 99)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_ST_Net_SetProxy
return external_call(global._SXMS2_ST_Net_SetProxy,argument0);
/*The Arguments:
Arg0 = STRING - The name of the proxy (in host:port format)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_ST_Open
external_call(global._SXMS2_ST_OpenName,argument0);
return external_call(global._SXMS2_ST_Open,argument1,argument2,argument3,argument4,argument5,argument6,argument7,argument8);
/*The Arguments:
Arg0 = STRING - The name of the file to open
Arg1 = REAL - The index to assign the loaded file
Arg2 = REAL - The starting offset (optional)
Arg3 = REAL - The length of the file (only use if Arg2 is > 0)
Arg4 = REAL - The looping method (0 to 2)
Arg5 = REAL - Whether to use hardware (1) or not (0)
Arg6 = REAL - Whether to be MPEG Accurate (1) or not (0)
Arg7 = REAL - Whether to open with NON-Blocking (1) or not (0)
Arg8 = REAL - Whether to enable DirectX 8.1 FX (1) or not (0)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_ST_Play
return external_call(global._SXMS2_ST_Play,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to play on
Arg1 = REAL - The index of the stream to play
Return = REAL - Successful (The channel handle played on) or Failed (-1)
*/

#define SXMS2_ST_SetBufferSize
return external_call(global._SXMS2_ST_SetBufferSize,argument0);
/*The Arguments:
Arg0 = REAL - The size of the buffer (in milliseconds)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_ST_SetLoopCount
return external_call(global._SXMS2_ST_SetLoopCount,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The index of a loaded stream
Arg1 = REAL - The number of times to loop ( <0 is infinity)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_ST_SetLoopPoints
return external_call(global._SXMS2_ST_SetLoopPoints,argument0,argument1,argument2);
/*The Arguments:
Arg0 = REAL - The index of a loaded stream
Arg1 = REAL - The starting loop point in PCM SAMPLES
Arg2 = REAL - The ending loop point in PCM SAMPLES
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_ST_SetPosition
return external_call(global._SXMS2_ST_SetPosition,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The index of a loaded stream
Arg1 = REAL - The position to set in bytes
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_ST_SetSubStreams
return external_call(global._SXMS2_ST_SetSubStreams,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The index of a loaded stream
Arg1 = REAL - The number of the substream to set
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_ST_SetTime
return external_call(global._SXMS2_ST_SetTime,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The index of a loaded stream
Arg1 = REAL - The position to set (in milliseconds)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_ST_Stop
return external_call(global._SXMS2_ST_Stop,argument0);
/*The Arguments:
Arg0 = REAL - The index of a loaded and playing stream
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_CD_OpenTray
return external_call(global._SXMS2_CD_OpenTray,argument0,argument1);
/*The Arguments:
Arg0 = STRING - The character of the drive to open/close (0 for default)
Arg1 = REAL - 1 to open, 0 to close.
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_CD_GetNumTracks
return external_call(global._SXMS2_CD_GetNumTracks,argument0);
/*The Arguments:
Arg0 = STRING - The character of the drive to check
Return = REAL - The number of tracks
*/

#define SXMS2_CD_GetPaused
return external_call(global._SXMS2_CD_GetPaused,argument0);
/*The Arguments:
Arg0 = STRING - The character of the drive to check
Return = REAL - Paused (1) or Not (0)
*/

#define SXMS2_CD_GetTrack
return external_call(global._SXMS2_CD_GetTrack,argument0);
/*The Arguments:
Arg0 = STRING - The character of the drive to check
Return = REAL - The current tracks number
*/

#define SXMS2_CD_GetTrackLength
return external_call(global._SXMS2_CD_GetTrackLength,argument0,argument1);
/*The Arguments:
Arg0 = STRING - The character of the drive to check
Arg1 = REAL - The track to check
Return = REAL - The length of the track selected (in milliseconds)
*/

#define SXMS2_CD_GetTrackTime
return external_call(global._SXMS2_CD_GetTrackTime,argument0,argument1);
/*The Arguments:
Arg0 = STRING - The character of the drive to check
Arg1 = REAL - The track to check
Return = REAL - The current track time (in milliseconds)
*/

#define SXMS2_CD_Play
return external_call(global._SXMS2_CD_Play,argument0,argument1);
/*The Arguments:
Arg0 = STRING - The character of the drive to check
Arg1 = REAL - The track to play
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_CD_SetPaused
return external_call(global._SXMS2_CD_SetPaused,argument0,argument1);
/*The Arguments:
Arg0 = STRING - The character of the drive to set
Arg1 = REAL - The track to pause
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_CD_SetPlayMode
return external_call(global._SXMS2_CD_SetPlayMode,argument0,argument1);
/*The Arguments:
Arg0 = STRING - The character of the drive to set
Arg1 = REAL - The play mode to use (0 to 3)
Return = NULL
*/

#define SXMS2_CD_SetTrackTime
return external_call(global._SXMS2_CD_SetTrackTime,argument0,argument1);
/*The Arguments:
Arg0 = STRING - The character of the drive to set
Arg1 = REAL - The time to set (in milliseconds)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_CD_SetVolume
return external_call(global._SXMS2_CD_SetVolume,argument0,argument1);
/*The Arguments:
Arg0 = STRING - The character of the drive to set
Arg1 = REAL - The volume to set (0 to 255)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_CD_Stop
return external_call(global._SXMS2_CD_Stop,argument0);
/*The Arguments:
Arg0 = STRING - The character of the drive to stop
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_DSP_ClearMixBuffer
return external_call(global._SXMS2_DSP_ClearMixBuffer);
/*The Arguments:
Return = NULL
*/

#define SXMS2_DSP_SetActive
return external_call(global._SXMS2_DSP_SetActive,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The unit to change active state (0 to 4)
Arg1 = REAL - Activate (1) or Deactivate (0)
Return = NULL
*/

#define SXMS2_DSP_GetActive
return external_call(global._SXMS2_DSP_GetActive,argument0);
/*The Arguments:
Arg0 = REAL - The unit to check active state (0 to 4)
Return = REAL - Active (1), Not Active (0), Error (-1)
*/

#define SXMS2_DSP_GetBufferLengthTotal
return external_call(global._SXMS2_DSP_GetBufferLengthTotal);
/*The Arguments:
Return = REAL - The length of the DSP buffer (in samples)
*/

#define SXMS2_DSP_SetPriority
return external_call(global._SXMS2_DSP_SetPriority,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The DSP unit to set the priority (0 to 4)
Arg1 = REAL - The priority for the selected unit (0 to 1000)
Return = NULL
*/

#define SXMS2_DSP_GetPriority
return external_call(global._SXMS2_DSP_GetPriority,argument0);
/*The Arguments:
Arg0 = REAL - The DSP unit to get the priority (0 to 4)
Return = REAL - The number of the priority (0 to 1000)
*/

#define SXMS2_DSP_GetSpectrum
return external_call(global._SXMS2_DSP_GetSpectrum,argument0);
/*The Arguments:
Arg0 = REAL - The spectrum section to return data from. (0 to 511)
Return = REAL - The percent of sound in that section.
*/

#define SXMS2_FX_Disable
return external_call(global._SXMS2_FX_Disable,argument0);
/*The Arguments:
Arg0 = REAL - The channel to disable effects on
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_FX_Enable
return external_call(global._SXMS2_FX_Enable,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The channel to set effects on
Arg1 = REAL - The effect to add (0 to 8)
Return = REAL - The FX id or Failed (-1)
*/

#define SXMS2_FX_SetChorus
return external_call(global._SXMS2_FX_SetChorus,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7);
/*The Arguments:
Arg0 = REAL - The FX id
Arg1 = REAL - Wet/Dry Mix
Arg2 = REAL - Depth
Arg3 = REAL - Feedback
Arg4 = REAL - Frequency
Arg5 = REAL - WaveForm
Arg6 = REAL - Delay
Arg7 = REAL - Phase
Return = REAL - Successful (1) or Failed (0)
*/

//Check documentation for full info

#define SXMS2_FX_SetCompressor
return external_call(global._SXMS2_FX_SetCompressor,argument0,argument1,argument2,argument3,argument4,argument5,argument6);
/*The Arguments:
Arg0 = REAL - The FX id
Arg1 = REAL - Gain
Arg2 = REAL - Attack
Arg3 = REAL - Release
Arg4 = REAL - Threshold
Arg5 = REAL - Ratio
Arg6 = REAL - Pre-Delay
Return = REAL - Successful (1) or Failed (0)
*/

//Check documentation for full info

#define SXMS2_FX_SetDistortion
return external_call(global._SXMS2_FX_SetDistortion,argument0,argument1,argument2,argument3,argument4,argument5);
/*The Arguments:
Arg0 = REAL - The FX id
Arg1 = REAL - Gain
Arg2 = REAL - Edge
Arg3 = REAL - Post EQ Center Frequency
Arg4 = REAL - Post EQ Bandwidth
Arg5 = REAL - Pre Lowpass Cutoff
Return = REAL - Successful (1) or Failed (0)
*/

//Check documentation for full info

#define SXMS2_FX_SetEcho
return external_call(global._SXMS2_FX_SetEcho,argument0,argument1,argument2,argument3,argument4,argument5);
/*The Arguments:
Arg0 = REAL - The FX id
Arg1 = REAL - Wet/Dry Mix
Arg2 = REAL - Feedback
Arg3 = REAL - Left Delay
Arg4 = REAL - Right Delay
Arg5 = REAL - Pan Delay
Return = REAL - Successful (1) or Failed (0)
*/

//Check documentation for full info

#define SXMS2_FX_SetFlanger
return external_call(global._SXMS2_FX_SetFlanger,argument0,argument1,argument2,argument3,argument4,argument5,argument6,argument7);
/*The Arguments:
Arg0 = REAL - The FX id
Arg1 = REAL - Wet/Dry Mix
Arg2 = REAL - Depth
Arg3 = REAL - Feedback
Arg4 = REAL - Frequency
Arg5 = REAL - WaveForm
Arg6 = REAL - Delay
Arg7 = REAL - Phase
Return = REAL - Successful (1) or Failed (0)
*/

//Check documentation for full info

#define SXMS2_FX_SetGargle
return external_call(global._SXMS2_FX_SetGargle,argument0,argument1,argument2);
/*The Arguments:
Arg0 = REAL - The FX id
Arg1 = REAL - Rate Hz
Arg2 = REAL - Wave Shape
Return = REAL - Successful (1) or Failed (0)
*/

//Check documentation for full info

#define SXMS2_FX_SetI3DL2Reverb
external_call(global._SXMS2_FX_SetI3DL2Reverb1,argument1,argument2,argument6,argument8);
return external_call(global._SXMS2_FX_SetI3DL2Reverb2,argument0,argument3,argument4,argument5,argument7,argument9,argument10,argument11,argument12);
/*The Arguments:
Arg0 = REAL - The FX id
Arg1 = REAL - Room
Arg2 = REAL - Room HF
Arg3 = REAL - Room Rolloff Factor
Arg4 = REAL - Decay Time
Arg5 = REAL - Decay HF Ratio
Arg6 = REAL - Reflections
Arg7 = REAL - Reflections Delay
Arg8 = REAL - Reverb
Arg9 = REAL - Reverb Delay
Arg10 = REAL - Diffusion
Arg11 = REAL - Density
Arg12 = REAL - HF Reference
Return = REAL - Successful (1) or Failed (0)
*/

//Check documentation for full info

#define SXMS2_FX_SetParamEQ
return external_call(global._SXMS2_FX_SetParamEQ,argument0,argument1,argument2,argument3);
/*The Arguments:
Arg0 = REAL - The FX id
Arg1 = REAL - Center
Arg2 = REAL - Bandwidth
Arg3 = REAL - Gain
Return = REAL - Successful (1) or Failed (0)
*/

//Check documentation for full info

#define SXMS2_FX_SetWavesReverb
return external_call(global._SXMS2_FX_SetWavesReverb,argument0,argument1,argument2,argument3,argument4);
/*The Arguments:
Arg0 = REAL - The FX id
Arg1 = REAL - In Gain
Arg2 = REAL - Reverb Mix
Arg3 = REAL - Reverb Time
Arg4 = REAL - High Frequency RT Ratio
Return = REAL - Successful (1) or Failed (0)
*/

//Check documentation for full info

#define SXMS2_R_GetDriver
return external_call(global._SXMS2_R_GetDriver);
/*The Arguments:
Return = REAL - Currently selected driver ID
*/

#define SXMS2_R_GetDriverName
return external_call(global._SXMS2_R_GetDriverName,argument0);
/*The Arguments:
Arg0 = REAL - The driver id number
Return = STRING - The name of the driver
*/

#define SXMS2_R_GetNumDrivers
return external_call(global._SXMS2_R_GetNumDrivers);
/*The Arguments:
Return = REAL - The number of available recording drivers
*/

#define SXMS2_R_GetPosition
return external_call(global._SXMS2_R_GetPosition);
/*The Arguments:
Return = REAL - The position of the last recorded input in samples
*/

#define SXMS2_R_SetDriver
return external_call(global._SXMS2_R_SetDriver,argument0);
/*The Arguments:
Arg0 = REAL - The recording driver to select (the id number)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_R_StartSample
return external_call(global._SXMS2_R_StartSample,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The index id number for the sample
Arg1 = REAL - whether to have looping recording (1) or not (0)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_R_Stop
return external_call(global._SXMS2_R_Stop);
/*The Arguments:
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MC_FreeSong
return external_call(global._SXMS2_MC_FreeSong,argument0);
/*The Arguments:
Arg0 = REAL - The index number of the Mod to free
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MC_LoadSongEx
external_call(global._SXMS2_MC_LoadSongExName,argument0);
return external_call(global._SXMS2_MC_LoadSongEx,argument1,argument2,argument3,argument4,argument5);
/*The Arguments:
Arg0 = STRING - The filename (and path) of the song to load
Arg1 = REAL - The index (slot) to load into
Arg2 = REAL - The starting offset
Arg3 = REAL - The total length of the file
Arg4 = REAL - Whether to use nonblocking or not
Arg5 = REAL - The style for looping
Return = REAL - Successful (1) or Not (0)
*/

#define SXMS2_MC_OptimizeChannels
return external_call(global._SXMS2_MC_OptimizeChannels,argument0,argument1,argument2);
/*The Arguments:
Arg0 = REAL - The mod index
Arg1 = REAL - Max channels before dropping occurs
Arg2 = REAL - Minimum volume (0 to 64)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MC_PlaySong
return external_call(global._SXMS2_MC_PlaySong,argument0);
/*The Arguments:
Arg0 = REAL - The mod index to play
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MC_SetLooping
return external_call(global._SXMS2_MC_SetLooping,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The mod index
Arg1 = REAL - Loop Forever (1) or just play once (0)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MC_SetMasterSpeed
return external_call(global._SXMS2_MC_SetMasterSpeed,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The mod index
Arg1 = REAL - The speed of playback (0.0 to 10.0)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MC_SetMasterVolume
return external_call(global._SXMS2_MC_SetMasterVolume,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The mod index
Arg1 = REAL - Volume (0 to 256)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MC_SetOrder
return external_call(global._SXMS2_MC_SetOrder,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The mod index
Arg1 = REAL - The order number
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MC_SetPanSeperation
return external_call(global._SXMS2_MC_SetPanSeperation,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The mod index
Arg1 = REAL - The seperation (mono 0.0 - 1.0 full stereo)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MC_SetPaused
return external_call(global._SXMS2_MC_SetPaused,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The mod index
Arg1 = REAL - Pause (1) or Not (0)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MC_SetReverb
return external_call(global._SXMS2_MC_SetReverb,argument0);
/*The Arguments:
Arg0 = REAL - Reverb on (1) or off (0) (only works for midi)
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MC_SetSample
return external_call(global._SXMS2_MC_SetSample,argument0,argument1,argument2);
/*The Arguments:
Arg0 = REAL - The mod index
Arg1 = REAL - slot number of sample spot inside mod
Arg2 = REAL - Sample index number to set
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MC_StopAllSongs
return external_call(global._SXMS2_MC_StopAllSongs);
/*The Arguments:
Return = NULL
*/

#define SXMS2_MC_StopSong
return external_call(global._SXMS2_MC_StopSong,argument0);
/*The Arguments:
Arg0 = REAL - The index number of mod to stop
Return = NULL
*/

#define SXMS2_MI_GetBPM
return external_call(global._SXMS2_MI_GetBPM,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The current BPM of the song
*/

#define SXMS2_MI_GetGlobalVolume
return external_call(global._SXMS2_MI_GetGlobalVolume,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The current "global" volume
*/

#define SXMS2_MI_GetMasterVolume
return external_call(global._SXMS2_MI_GetMasterVolume,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The current "master" volume
*/

#define SXMS2_MI_GetName
return external_call(global._SXMS2_MI_GetName,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = STRING - The name of the loaded mod file
*/

#define SXMS2_MI_GetNumChannels
return external_call(global._SXMS2_MI_GetNumChannels,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The number of channels in the mod
*/

#define SXMS2_MI_GetNumInstruments
return external_call(global._SXMS2_MI_GetNumInstruments,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The number of instruments in a mod
*/

#define SXMS2_MI_GetNumOrders
return external_call(global._SXMS2_MI_GetNumOrders,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The number of orders in a mod
*/

#define SXMS2_MI_GetNumPatterns
return external_call(global._SXMS2_MI_GetNumPatterns,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The number of patterns in a mod
*/

#define SXMS2_MI_GetNumSamples
return external_call(global._SXMS2_MI_GetNumSamples,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The number of samples in a mod
*/

#define SXMS2_MI_GetOpenState
return external_call(global._SXMS2_MI_GetOpenState,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The opening state of a file (0 to -3)
*/

#define SXMS2_MI_GetOrder
return external_call(global._SXMS2_MI_GetOrder,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The current order in a mod
*/

#define SXMS2_MI_GetPattern
return external_call(global._SXMS2_MI_GetPattern,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The current pattern in a mod
*/

#define SXMS2_MI_GetPatternLength
return external_call(global._SXMS2_MI_GetPatternLength,argument0,argument1);
/*The Arguments:
Arg0 = REAL - A mod index
Arg1 = REAL - Pattern number
Return = REAL - The length of the pattern (in rows)
*/

#define SXMS2_MI_GetPaused
return external_call(global._SXMS2_MI_GetPaused,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - Whether Paused (1) or not (0)
*/

#define SXMS2_MI_GetRealChannel
return external_call(global._SXMS2_MI_GetRealChannel,argument0,argument1);
/*The Arguments:
Arg0 = REAL - A mod index
Arg1 = REAL - The mod channel
Return = REAL - The FMOD channel being used for the selected mod channel
*/

#define SXMS2_MI_GetRow
return external_call(global._SXMS2_MI_GetRow,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The current row in the current pattern
*/

#define SXMS2_MI_ExportSample
return external_call(global._SXMS2_MI_ExportSample,argument0,argument1,argument2);
/*The Arguments:
Arg0 = STRING - The filename (and path) to save sample into (wav format)
Arg1 = REAL - The mod index
Arg2 = REAL - The sample number to export
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_MI_GetSpeed
return external_call(global._SXMS2_MI_GetSpeed,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The current mod speed
*/

#define SXMS2_MI_GetTime
return external_call(global._SXMS2_MI_GetTime,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - The current time that has passed since start
*/

#define SXMS2_MI_IsFinished
return external_call(global._SXMS2_MI_IsFinished,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - Finished (1) or Not (0)
*/

#define SXMS2_MI_IsPlaying
return external_call(global._SXMS2_MI_IsPlaying,argument0);
/*The Arguments:
Arg0 = REAL - A mod index
Return = REAL - Playing (1) or Not (0)
*/

#define SXMS2_W_Init
dll = "SXMS2.dll" /*Name of DLL to use*/

/*Setup of the WinAmp Plugin Support Functions (20)*/
global._SXMS2_W_Init = external_define(dll,"SXMS2_W_Init",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_W_RemovePlugIn = external_define(dll,"SXMS2_W_RemovePlugIn",dll_cdecl,ty_real,0);
global._SXMS2_W_RemovePlugOut = external_define(dll,"SXMS2_W_RemovePlugOut",dll_cdecl,ty_real,0);
global._SXMS2_W_Close = external_define(dll,"SXMS2_W_Close",dll_cdecl,ty_real,0);
global._SXMS2_W_LoadPlugIn = external_define(dll,"SXMS2_W_LoadPlugIn",dll_cdecl,ty_real,1,ty_string);
global._SXMS2_W_LoadPlugOut = external_define(dll,"SXMS2_W_LoadPlugOut",dll_cdecl,ty_real,1,ty_string);
global._SXMS2_W_Stop = external_define(dll,"SXMS2_W_Stop",dll_cdecl,ty_real,0);
global._SXMS2_W_Play = external_define(dll,"SXMS2_W_Play",dll_cdecl,ty_real,1,ty_string);
global._SXMS2_W_IsPlaying = external_define(dll,"SXMS2_W_IsPlaying",dll_cdecl,ty_real,0);
global._SXMS2_W_SetPaused = external_define(dll,"SXMS2_W_SetPaused",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_W_GetPaused = external_define(dll,"SXMS2_W_GetPaused",dll_cdecl,ty_real,0);
global._SXMS2_W_GetLength = external_define(dll,"SXMS2_W_GetLength",dll_cdecl,ty_real,0);
global._SXMS2_W_GetOutputTime = external_define(dll,"SXMS2_W_GetOutputTime",dll_cdecl,ty_real,0);
global._SXMS2_W_SetOutputTime = external_define(dll,"SXMS2_W_SetOutputTime",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_W_SetVolume = external_define(dll,"SXMS2_W_SetVolume",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_W_GetVolume = external_define(dll,"SXMS2_W_GetVolume",dll_cdecl,ty_real,0);
global._SXMS2_W_SetPan = external_define(dll,"SXMS2_W_SetPan",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_W_Configure = external_define(dll,"SXMS2_W_Configure",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_W_About = external_define(dll,"SXMS2_W_About",dll_cdecl,ty_real,1,ty_real);
global._SXMS2_W_GetExtentions = external_define(dll,"SXMS2_W_GetExtentions",dll_cdecl,ty_string,0);

/*The Initializing of the SXMS WinAmp Plugin Support*/
return external_call(global._SXMS2_W_Init,window_handle());
/*The Arguments:
-Arg0- (Not filled by user) The handle of the GM window
Return = NULL
*/

#define SXMS2_W_RemovePlugIn
return external_call(global._SXMS2_W_RemovePlugIn);
/*The Arguments:
Return = NULL
*/

#define SXMS2_W_RemovePlugOut
return external_call(global._SXMS2_W_RemovePlugOut);
/*The Arguments:
Return = NULL
*/

#define SXMS2_W_Close
return external_call(global._SXMS2_W_Close);
/*The Arguments:
Return = NULL
*/

#define SXMS2_W_LoadPlugIn
return external_call(global._SXMS2_W_LoadPlugIn,argument0);
/*The Arguments:
Arg0 = STRING - The name of the input plugin to load
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_W_LoadPlugOut
return external_call(global._SXMS2_W_LoadPlugOut,argument0);
/*The Arguments:
Arg0 = STRING - The name of the output plugin to load
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_W_Stop
return external_call(global._SXMS2_W_Stop);
/*The Arguments:
Return = NULL
*/

#define SXMS2_W_Play
return external_call(global._SXMS2_W_Play,argument0);
/*The Arguments:
Arg0 = STRING - Name of file to play
Return = REAL - Successful (1) or Failed (0)
*/

#define SXMS2_W_IsPlaying
return external_call(global._SXMS2_W_IsPlaying);
/*The Arguments:
Return = REAL - Playing (1) or Not (0)
*/

#define SXMS2_W_SetPaused
return external_call(global._SXMS2_W_SetPaused,argument0);
/*The Arguments:
Arg0 = REAL - Whether to pause (1) or not (0)
Return = NULL
*/

#define SXMS2_W_GetPaused
return external_call(global._SXMS2_W_GetPaused);
/*The Arguments:
Return = REAL - Whether paused (1) or not (0)
*/

#define SXMS2_W_GetLength
return external_call(global._SXMS2_W_GetLength);
/*The Arguments:
Return = REAL - The length of the current song (in milliseconds)
*/

#define SXMS2_W_GetOutputTime
return external_call(global._SXMS2_W_GetOutputTime);
/*The Arguments:
Return = REAL - The current time of the current song (in milliseconds)
*/

#define SXMS2_W_SetOutputTime
return external_call(global._SXMS2_W_SetOutputTime,argument0);
/*The Arguments:
Arg0 = REAL - The time to set the current song to (in milliseconds)
Return = NULL
*/

#define SXMS2_W_SetVolume
return external_call(global._SXMS2_W_SetVolume,argument0);
/*The Arguments:
Arg0 = REAL - Setting the volume of the current song (0 - 255)
Return = NULL
*/

#define SXMS2_W_GetVolume
return external_call(global._SXMS2_W_GetVolume);
/*The Arguments:
Return = REAL - The current volume
*/

#define SXMS2_W_SetPan
return external_call(global._SXMS2_W_SetPan,argument0);
/*The Arguments:
Arg0 = REAL - The panning of the song (-127 to 127)
Return = NULL
*/

#define SXMS2_W_Configure
return external_call(global._SXMS2_W_Configure,argument0);
/*The Arguments:
Arg0 = REAL - Select for Plug In (0) or Plug Out (1)
Return = NULL
*/

#define SXMS2_W_About
return external_call(global._SXMS2_W_About,argument0);
/*The Arguments:
Arg0 = REAL - Select for Plug In (0) or Plug Out (1)
Return = NULL
*/

#define SXMS2_W_GetExtentions
return external_call(global._SXMS2_W_GetExtentions);
/*The Arguments:
Return = STRING - Displays all extentions the input plug can play
*/

#define SXMS2_S_BitRate
return external_call(global._SXMS2_S_BitRate,argument0);
/*The Arguments:
Arg0 = REAL - The stream index
Return = REAL - The current bit rate
*/

#define SXMS2_S_ModRows
return external_call(global._SXMS2_S_ModRows,argument0,argument1);
/*The Arguments:
Arg0 = REAL - The return type:  current row (0) or total rows (1)
Arg1 = REAL - The mod index
Return = REAL - Either current or total rows in mod file
*/

#define SXMS2_S_PercentComplete
return external_call(global._SXMS2_S_PercentComplete,argument0,argument1,argument2,argument3);
/*The Arguments:
Arg0 = REAL - System (0 = Stream, 1 = Mod, 2 = Sample, 3 = CD Player, 4 = WinPlugs)
Arg1 = REAL - The stream, mod, or sample index
Arg2 = REAL - The channel being played in (used for Sample system)
Arg3 = STRING - Drive letter (Used for CD Player system)
Return = REAL - The current percent complete (as decimal 0.00 to 1.00)
*/

#define SXMS2_S_SaveToWav
return external_call(global._SXMS2_S_SaveToWav,argument0,argument1);
/*The Arguments:
Arg0 = STRING - Filename (and path) to save into
Arg1 = REAL - The sample index
Return = REAL - Successful (1) or Failed (0)
*/
