// Define export macro
#define export extern __declspec( dllexport )
//
#include <windows.h>
#include <mmsystem.h>
#include <stdio.h>
#include <math.h>
#include "bass.h"

DWORD starttime, pausedtime;
HMUSIC mod;
HSTREAM str;
DWORD time,level,left,right,aeg=0;
QWORD pos;
int a; 
char title[101]="", kirje[101]="", br[16]="";


/* looping synchronizer, resets the clock */
void CALLBACK LoopSync(HSYNC handle, DWORD channel, DWORD data, DWORD user){
   starttime=timeGetTime();
}


/* update stream title from metadata */
void DoMeta(char *meta){
	char *p;
	if (meta && (p=strstr(meta,"StreamTitle='"))) {
		p=strdup(p+13);
		strchr(p,';')[-1]=0;
		strncpy(title,p,100);
		free(p);
	}
}


/* title sync callback */
void CALLBACK MetaSync(HSYNC handle, DWORD channel, DWORD data, DWORD user){
	DoMeta((char*)data);
}


/* init */
export double Gm_BASS_Init(void){
   if (BASS_GetVersion()!=MAKELONG(2,0))
      return 1;
   if (!BASS_Init(1,44100,0,0,NULL))
      return 2;
   return 0;
}


/* load sound */
export double Gm_BASS_Load(PCHAR lugu){
    if (str) BASS_StreamFree(str);
    if (mod) BASS_MusicFree(mod);
    br[0]=0;
    kirje[0]=0;
    title[0]=0;

    /* try streaming the file/url */
    if ((str=BASS_StreamCreateFile(FALSE,lugu,0,0,0)) || (str=BASS_StreamCreateURL(lugu,0,BASS_STREAM_META,NULL,0))) 
        {
	    /* set a synchronizer for when the stream reaches the end */
	    BASS_ChannelSetSync(str,BASS_SYNC_END,0,&LoopSync,0);
	    /* get the broadcast name and bitrate */
	    char *icy=BASS_StreamGetTags(str,BASS_TAG_ICY);
	    if (icy)
	         for (;*icy;icy+=strlen(icy)+1) {
                if (!memcmp(icy,"icy-name:",9))
                    strncpy(kirje,icy+9,100);
                if (!memcmp(icy,"icy-br:",7)) {
                    strcat(br,"bitrate: ");
                    strncat(br,icy+7,6);
                    }
				}
        // ????????? 
	    if (BASS_StreamGetFilePosition(str,BASS_FILEPOS_DOWNLOAD)==-1)
	         strncpy(title,lugu,100);

        // set the meta sync
	    DoMeta(BASS_StreamGetTags(str,BASS_TAG_META));
        BASS_ChannelSetSync(str,BASS_SYNC_META,0,&MetaSync,0);  
 	    pos=BASS_StreamGetLength(str);}
    else {
	    /* try loading the MOD (with looping, sensitive ramping, and calculate the duration) */
	    if (!(mod=BASS_MusicLoad(FALSE,lugu,0,0,BASS_MUSIC_LOOP|BASS_MUSIC_RAMPS|BASS_MUSIC_CALCLEN,0)))
	         return 0; //not a MOD either 
 
        /* set a synchronizer for when the MOD reaches the end */
        BASS_ChannelSetSync(mod,BASS_SYNC_END,0,&LoopSync,0);
        /* count channels */
        for (a=0;BASS_MusicGetVolume(mod,a)!=-1;a++);
        snprintf(title,100,"\"%s\" [%d chans, %d orders]",BASS_MusicGetName(mod),a,BASS_MusicGetLength(mod,FALSE));
        pos=BASS_MusicGetLength(mod,TRUE);
     }
     /* time length */
     time=(DWORD)BASS_ChannelBytes2Seconds(str?str:mod,pos);
     return 1;
}


/* Unload */
export PCHAR Gm_Bass_Unload(void) {
    br[0]=0;
    kirje[0]=0;
    title[0]=0;
    if (str) BASS_StreamFree(str);
    if (mod) BASS_MusicFree(mod);
    return 0;
}


/* if Bass is playing */
export double Gm_Bass_Is_Playing(void){ 
    return BASS_ChannelIsActive(str?str:mod);
}


/* Stopp playing */
export double Gm_Bass_Stopp(void){
    return BASS_ChannelStop(str?str:mod);    
}


/* Play arguments: 0 -play once, 1 -loop */
export double Gm_Bass_Play(double cn){
    if (cn==0){
        if (str) BASS_StreamPlay(str,0,0);
        else BASS_MusicPlayEx(mod,0,BASS_MUSIC_RAMP,0);}
    else{
        if (str) BASS_StreamPlay(str,0,BASS_SAMPLE_LOOP);
        else BASS_MusicPlayEx(mod,0,BASS_MUSIC_LOOP|BASS_MUSIC_RAMP,0);
        }
    starttime=timeGetTime();
    return 1;
}


/* Pause */
export PCHAR Gm_Bass_Pause(void){
    if (BASS_ChannelIsActive(str?str:mod)==3){
        BASS_ChannelResume(str?str:mod);
        starttime+=timeGetTime()-pausedtime;}
    else {
        BASS_ChannelPause(str?str:mod); 
        pausedtime=timeGetTime();}
    return 0;           
}


/* get string time. arguments: 0 -play time, 1 time left, 2 lenght. */
export PCHAR Gm_Bass_Time(double cn){
    static char aeg[9]={0};
    long time2=0, time0=0;
    float time1=0;
    switch (BASS_ChannelIsActive(str?str:mod)){
        case 1: time2=timeGetTime()-starttime;
                time1=time-ceil(time2/1000);
                time0=(long)time1;
                break;
        case 3: time2=pausedtime -starttime;
                time1=time-ceil(time2/1000);
                time0=(long)time1;
        }
    if (time0<0) time0=0;
    if (time2<0) time2=0;
    if (cn==0) snprintf(aeg,8,"%d:%02d",time2/60000,(time2/1000)%60);
    if (cn==1) snprintf(aeg,8,"%d:%02d",time0/60,time0%60);
    if (cn==2) snprintf(aeg,8,"%d:%02d",time/60,time%60);
    return aeg;
}


/* return Tags. arguments: t -title, i -ICY, b -bitrate */
export PCHAR Gm_Bass_Tags(PCHAR cn){ 
    if (!memcmp(cn,"t",1)) return title;
    if (!memcmp(cn,"i",1)) return kirje;
    if (!memcmp(cn,"b",1)) return br;
    return "unknown argument type! usage: 't' 'i' 'b'";
}


/* return staatus string */
export PCHAR Gm_Bass_State(void){ 
    int st=BASS_ChannelIsActive(str?str:mod);
    if (st==1) return "PLYING";
    if (st==0) return "STOPPED";
    if (st==2) return "STALLED";
    if (st==3) return "PAUSED";
}


/* Set Atriputes. arguments: f -freguency, v- volume, p -palance. */
export PCHAR Gm_Bass_Voluum(PCHAR f, PCHAR v, PCHAR p){
    static int fd, vd, pd;
    sscanf(f,"%d",&fd); 
    sscanf(v,"%d",&vd); 
    sscanf(p,"%d",&pd);
    BASS_ChannelSetAttributes(str?str:mod,fd,vd,pd);
    return 0;    
}


/* Get Level. argumenc: l -left channel, r -right */
export double Gm_Bass_Level(PCHAR cn){
    level=BASS_ChannelGetLevel(str?str:mod);
    if (level !=-1){
        if (!memcmp(cn,"l",1)) {left= LOWORD(level); return left;}
        if (!memcmp(cn,"r",1)) {right= HIWORD(level); return right;}
        }
    return 0;
}


/* Get Positsioon. arguments: 1 -total lenght, 0 -play time, 2 -positsioon in % */
export double Gm_Bass_Pos(double cn){
    if (cn==1) return time;
    long time2=0;
    switch (BASS_ChannelIsActive(str?str:mod)){
        case 1: time2=(timeGetTime()-starttime)/1000;
                break;
        case 3: time2=(pausedtime -starttime)/1000;
        }
    if (cn==0)return time2;
    double p=0;
    if ((time2>0)&&(time>0))p=((double)time2/(double)time);
    return floor(p*100);
}


/* return Errorcode */
export double Gm_Bass_Error(void){ 
    return BASS_ErrorGetCode();
}


/* return Buffer size */
export double Gm_Bass_Puffer(void){ 
    if (BASS_StreamGetFilePosition(str,BASS_FILEPOS_DOWNLOAD)!=-1)
    return (BASS_StreamGetFilePosition(str?str:mod,BASS_FILEPOS_DOWNLOAD)-BASS_StreamGetFilePosition(str?str:mod,BASS_FILEPOS_DECODE));
    else return 0;
}

