#define INSTRUCTIONS
/*
*
* How to use these scripts:
*
* Key:
* return_value script_name(parameters)
* 
* <true or false> bgm_init()
* -------------------------------------------
*  This must be called once (and ONLY once) before any other bgm
*  scripts are used.
*  Returns wether or not the initialization of BASS.DLL worked.
* 
* <none> bgm_close()
* -------------------------------------------
*  Closes down BGM. You don't normally need to call this because
*  GameMaker will automatically close it when the program ends.
* 
* <none> bgm_play(filename)
* -------------------------------------------
*  Plays the file in the given filename, or restarts it if it
*  is already playing. If you play a new song while a song is
*  already being played, the old song will be stopeed and
*  unloaded from memory.
* 
* <none> bgm_stop()
* --------------------------------------------
*  Stops the song that is currently playing.
*
* <none> bgm_pause()
* --------------------------------------------
*  Pauses the song that's playing.
*
* <none> bgm_unpause()
* --------------------------------------------
*  Unpauses the song that's paused.
*  Note that calling bgm_play() will start the song
*  over instead of resuming it.
*
* <volume or none> bgm_vol(volume or -1)
* --------------------------------------------
*  Either gets or sets the playing volume.
*  The volume may be between 0 and 100.
*  Pass -1 (or negative value) to make it
*  return the current playing volume rather than
*  setting it.
* 
* <true, false or 2> bgm_isplaying()
* --------------------------------------------
*  Returns wethor or not a song is playing.
*  Returns 2 if the song is paused but not stopped.
* 
*/
#define bgm_init
STR = "BGM.dll";

global._BGM_init = external_define(STR,"bgm_init",dll_stdcall,ty_real,0);
global._BGM_play = external_define(STR,"song_play",dll_stdcall,ty_real,1,ty_string);
global._BGM_stop = external_define(STR,"song_stop",dll_stdcall,ty_real,0);
global._BGM_vol = external_define(STR,"song_vol",dll_stdcall,ty_real,1,ty_real);
global._BGM_pause = external_define(STR,"song_pause",dll_stdcall,ty_real,0);
global._BGM_unpause = external_define(STR,"song_unpause",dll_stdcall,ty_real,0);
global._BGM_isplaying = external_define(STR,"song_isplaying",dll_stdcall,ty_real,0);


return external_call(global._BGM_init);
#define bgm_close
if (bgm_isplaying())
  bgm_stop();

external_free(global._BGM_init);
external_free(global._BGM_play);
external_free(global._BGM_stop);
external_free(global._BGM_vol);
external_free(global._BGM_isplaying);
#define bgm_play
return external_call(global._BGM_play,argument0);
#define bgm_stop
return external_call(global._BGM_stop);
#define bgm_pause
return external_call(global._BGM_pause);
#define bgm_unpause
return external_call(global._BGM_unpause);
#define bgm_vol
return external_call(global._BGM_vol,argument0);
#define bgm_isplaying
return external_call(global._BGM_isplaying);
