#include <cmath>
#include <vector>
using std::vector;
//#include <algorithm>
#include "dll.h"
#include "dlm.h"

//functions for adding models and checking if they collide.
//I plan to use vectors to store models

vector< vector<double> > G_modellist;//create global vector to hold model vectors
vector<double> G_modelradius;//create a vector to store each model's radius

//vector< vector<double> > G_modelrot;//create global vector to hold model rotations.  Will be reset after collision check.
//model_check_clearrot();
double G_modelrot[2][3];//Array to hold model rotations
double G_replacenum = 0;
double G_buffervector[3]={0,0,0};//A vector to store vector returns from functions so GM can retrive it
double useless = clear_rotations();
double G_rotations_enabled=1;

vector<double> temp_vector;
double modelSlot=0;

/*double add_model(){                   //| function to add a model vector to G_modellist
       vector<double> tmp;            //| create new model vector
       G_modellist.push_back(tmp);    //| stick new model vector in G_modellist
       (G_modellist[0]).pushback(5);
       return G_modellist.size();//don't need this code anymore.  just keeping for refrence.
}*/

export double _stdcall begin_define_model(){//begins definition of new model
       temp_vector.clear();
       return G_modellist.size();
}

export double _stdcall begin_replace_model(double modnum){//begins definition of <replaced> model
       if(modnum<G_modellist.size()){
          temp_vector.clear();
          G_replacenum=modnum;
          return modnum;
       }else{
          G_replacenum=0;
          return -1;
       }
}

export double _stdcall model_add_triangle(double x1,double y1,double z1,double x2,double y2,double z2,double x3,double y3,double z3){
       temp_vector.push_back(x1);
       temp_vector.push_back(y1);
       temp_vector.push_back(z1);
       
       temp_vector.push_back(x2);
       temp_vector.push_back(y2);
       temp_vector.push_back(z2);
       
       temp_vector.push_back(x3);
       temp_vector.push_back(y3);
       temp_vector.push_back(z3);
       
       return(1);
}

export double _stdcall model_add_point(double x1,double y1,double z1){//adds point to model.  Must be called in sets of three.
       temp_vector.push_back(x1);
       temp_vector.push_back(y1);
       temp_vector.push_back(z1);
       
       return(1);
}

export double _stdcall end_define_model(){
       G_modellist.push_back(temp_vector);//save the model for later use
       G_modelradius.push_back(model_get_radius( G_modellist.size()-1 ));//save the radius
       temp_vector.clear();
       return(1);
}

export double _stdcall end_replace_model(){
       G_modellist[(int) G_replacenum]=temp_vector;
       G_modelradius[(int)G_replacenum]=model_get_radius( (int)G_replacenum );
       temp_vector.clear();
       return(1);
}
       
export double _stdcall get_model_number(){
       return(G_modellist.size());
}

export double _stdcall model_get_triangles(double modelnumber){
       if(modelnumber<G_modellist.size()){
            return(G_modellist[(int) modelnumber].size()/9);
       }else{
             return(0);
       }
}



/************************************************************************
  From here down is model collision code.  Above is model definition.
************************************************************************/


export double _stdcall model_check_collision(double mod1, double mod1_xpos, double mod1_ypos, double mod1_zpos, double mod2, double mod2_xpos, double mod2_ypos, double mod2_zpos){//must add arguments for transformations
       double t_1_p_1[3],t_1_p_2[3],t_1_p_3[3],  t_2_p_1[3],t_2_p_2[3],t_2_p_3[3],hit=0;

       if(G_modellist.size()>(mod1>?mod2)){
              if(sphere_sphere_intersect(mod1_xpos,mod1_ypos,mod1_zpos,G_modelradius[(int) mod1],  mod2_xpos,mod2_ypos,mod2_zpos,G_modelradius[(int) mod2])){
                     clear_rotations();
                     return(0);
              }
              for(int ML1=0;  ML1<G_modellist[(int) mod1].size();  ML1+=9){
                      t_1_p_1[0]=G_modellist[(int) mod1][ML1+0];//triangle 1   point 1
                      t_1_p_1[1]=G_modellist[(int) mod1][ML1+1];
                      t_1_p_1[2]=G_modellist[(int) mod1][ML1+2];
                      
                      t_1_p_2[0]=G_modellist[(int) mod1][ML1+3];//triangle 1   point 2
                      t_1_p_2[1]=G_modellist[(int) mod1][ML1+4];
                      t_1_p_2[2]=G_modellist[(int) mod1][ML1+5];
                      
                      t_1_p_3[0]=G_modellist[(int) mod1][ML1+6];//triangle 1   point 3
                      t_1_p_3[1]=G_modellist[(int) mod1][ML1+7];
                      t_1_p_3[2]=G_modellist[(int) mod1][ML1+8];
                      
                      if(G_rotations_enabled==1){//Rotate the points if enabled
                              apply_rotation2(t_1_p_1,0);
                              apply_rotation2(t_1_p_2,0);
                              apply_rotation2(t_1_p_3,0);
                      }
                      //Translate the points relative to models position
                      //Translate point 1
                      t_1_p_1[0]+=mod1_xpos;
                      t_1_p_1[1]+=mod1_ypos;
                      t_1_p_1[2]+=mod1_zpos;
                      //Translate point 2
                      t_1_p_2[0]+=mod1_xpos;
                      t_1_p_2[1]+=mod1_ypos;
                      t_1_p_2[2]+=mod1_zpos;
                      //Translate Point 3
                      t_1_p_3[0]+=mod1_xpos;
                      t_1_p_3[1]+=mod1_ypos;
                      t_1_p_3[2]+=mod1_zpos;

                      
                      for(int ML2=0;  ML2<G_modellist[(int) mod2].size();  ML2+=9){
                              t_2_p_1[0]=G_modellist[(int) mod2][ML2+0];//triangle 2   point 1
                              t_2_p_1[1]=G_modellist[(int) mod2][ML2+1];
                              t_2_p_1[2]=G_modellist[(int) mod2][ML2+2];
                              
                              t_2_p_2[0]=G_modellist[(int) mod2][ML2+3];//triangle 2   point 2
                              t_2_p_2[1]=G_modellist[(int) mod2][ML2+4];
                              t_2_p_2[2]=G_modellist[(int) mod2][ML2+5];

                              t_2_p_3[0]=G_modellist[(int) mod2][ML2+6];//triangle 2   point 3
                              t_2_p_3[1]=G_modellist[(int) mod2][ML2+7];
                              t_2_p_3[2]=G_modellist[(int) mod2][ML2+8];
                              
                              if(G_rotations_enabled==1){//Rotate the points if enabled
                                   apply_rotation2(t_2_p_1,1);
                                   apply_rotation2(t_2_p_2,1);
                                   apply_rotation2(t_2_p_3,1);
                              }
                              //Translate the points relative to models position
                              //Translate point 1
                              t_2_p_1[0]+=mod2_xpos;
                              t_2_p_1[1]+=mod2_ypos;
                              t_2_p_1[2]+=mod2_zpos;
                              //Translate point 2
                              t_2_p_2[0]+=mod2_xpos;
                              t_2_p_2[1]+=mod2_ypos;
                              t_2_p_2[2]+=mod2_zpos;
                              //Translate Point 3
                              t_2_p_3[0]+=mod2_xpos;
                              t_2_p_3[1]+=mod2_ypos;
                              t_2_p_3[2]+=mod2_zpos;
                              //must only test triangles if they first pass sphere collision test
                              //maybe use only sphere if precision is set to low
                              
                              
                              
                              //hit=tri_tri_intersect(t_1_p_1,t_1_p_2,t_1_p_3,   t_2_p_1,t_2_p_2,t_2_p_3);
                              //hit=TriTriEllipsoid(t_1_p_1,t_1_p_2,t_1_p_3,   t_2_p_1,t_2_p_2,t_2_p_3);
                              hit=NoDivTriTriIsect(t_1_p_1,t_1_p_2,t_1_p_3,   t_2_p_1,t_2_p_2,t_2_p_3);
                              //^^all above 3 functions work.
                              if(hit!=0){
                                         clear_rotations();
                                         return(1);
                              }
                      }
              }
              clear_rotations();
              return(0);
       }else{
             clear_rotations();
             return(0);
       }
}

export double _stdcall model_check_ray_collision(double mod1, double mod1_xpos, double mod1_ypos, double mod1_zpos, double xorig, double yorig, double zorig, double xdir, double ydir, double zdir){//must add arguments for transformations
       double t_1_p_1[3],t_1_p_2[3],t_1_p_3[3],  t_2_p_1[3],t_2_p_2[3],t_2_p_3[3],t=0,u=0,v=0,hit=0;

       if(G_modellist.size()>mod1){
              double orig[3]={xorig,yorig,zorig};
              double dir[3]={xdir,ydir,zdir};
              double dist=0;
              for(int ML1=0;  ML1<G_modellist[(int) mod1].size();  ML1+=9){
                      t_1_p_1[0]=G_modellist[(int) mod1][ML1+0];//triangle 1   point 1

                      t_1_p_1[1]=G_modellist[(int) mod1][ML1+1];
                      t_1_p_1[2]=G_modellist[(int) mod1][ML1+2];
                      
                      t_1_p_2[0]=G_modellist[(int) mod1][ML1+3];//triangle 1   point 2
                      t_1_p_2[1]=G_modellist[(int) mod1][ML1+4];
                      t_1_p_2[2]=G_modellist[(int) mod1][ML1+5];

                      t_1_p_3[0]=G_modellist[(int) mod1][ML1+6];//triangle 1   point 3
                      t_1_p_3[1]=G_modellist[(int) mod1][ML1+7];
                      t_1_p_3[2]=G_modellist[(int) mod1][ML1+8];
                      
                      //apply transformations to each point as loaded
                      
                      if(G_rotations_enabled==1){//Rotate the points if enabled
                              apply_rotation2(t_1_p_1,0);
                              apply_rotation2(t_1_p_2,0);
                              apply_rotation2(t_1_p_3,0);
                      }
                      //Translate the points relative to models position
                      //Translate point 1
                      t_1_p_1[0]+=mod1_xpos;
                      t_1_p_1[1]+=mod1_ypos;
                      t_1_p_1[2]+=mod1_zpos;
                      //Translate point 2
                      t_1_p_2[0]+=mod1_xpos;
                      t_1_p_2[1]+=mod1_ypos;
                      t_1_p_2[2]+=mod1_zpos;
                      //Translate Point 3
                      t_1_p_3[0]+=mod1_xpos;
                      t_1_p_3[1]+=mod1_ypos;
                      t_1_p_3[2]+=mod1_zpos;
                      
                      //Check for collisions
                      if(intersect_ray_triangle2(orig,dir,t_1_p_1,t_1_p_2,t_1_p_3,&t,&u,&v)){
                              if((t<dist)||(dist==0)){
                                 if(t>0){
                                       dist=t;
                                       triangle_get_normal(G_buffervector,t_1_p_1,t_1_p_2,t_1_p_3);                                                      
                                       
                                 }
                              }
                      }
                      t=0;u=0;v=0;
              }
              if(dist!=0){
                   clear_rotations();
                   return dist;
              }
              clear_rotations();
              return(0);
       }else{
             clear_rotations();
             return(0);
       }
}

export double ray_bounce_triangle(double ray_x, double ray_y, double ray_z, double plane_x, double plane_y, double plane_z){
       //Calculates a new vector resulted by ray bouncing off of plane
       double ray[3]={ray_x,ray_y,ray_z};
       double plane[3]={plane_x,plane_y,plane_z};
       vector_bounce(ray,plane,G_buffervector);
       normalize_vector(G_buffervector);
       return(1);
}

export double get_vector_buffer(double component){
       return(G_buffervector[(int) component]);
}



double TriTriEllipsoid(double t_1_p_1[3],double t_1_p_2[3],double t_1_p_3[3],  double t_2_p_1[3],double t_2_p_2[3],double t_2_p_3[3]){

       double t1_xmax,t1_xmin,t1_xradius,t1_xcenter;//t1
       double t1_ymax,t1_ymin,t1_yradius,t1_ycenter;
       double t1_zmax,t1_zmin,t1_zradius,t1_zcenter;
       double t2_xmax,t2_xmin,t2_xradius,t2_xcenter;//t2
       double t2_ymax,t2_ymin,t2_yradius,t2_ycenter;
       double t2_zmax,t2_zmin,t2_zradius,t2_zcenter;

       t1_xmax=((t_1_p_1[0]>?t_1_p_2[0])>?t_1_p_3[0]);
       t1_xmin=((t_1_p_1[0]<?t_1_p_2[0])<?t_1_p_3[0]);
       t1_xradius=(t1_xmax-t1_xmin)/2;
       t1_xcenter=t1_xmin+t1_xradius;
                             
       t1_ymax=((t_1_p_1[1]>?t_1_p_2[1])>?t_1_p_3[1]);
       t1_ymin=((t_1_p_1[1]<?t_1_p_2[1])<?t_1_p_3[1]);
       t1_yradius=(t1_ymax-t1_ymin)/2;
       t1_ycenter=t1_ymin+t1_yradius;
       
       t1_zmax=((t_1_p_1[2]>?t_1_p_2[2])>?t_1_p_3[2]);
       t1_zmin=((t_1_p_1[2]<?t_1_p_2[2])<?t_1_p_3[2]);
       t1_zradius=(t1_zmax-t1_zmin)/2;
       t1_zcenter=t1_zmin+t1_zradius;
       
       
       t2_xmax=((t_2_p_1[0]>?t_2_p_2[0])>?t_2_p_3[0]);
       t2_xmin=((t_2_p_1[0]<?t_2_p_2[0])<?t_2_p_3[0]);
       t2_xradius=(t2_xmax-t2_xmin)/2;
       t2_xcenter=t2_xmin+t2_xradius;
                             
       t2_ymax=((t_2_p_1[1]>?t_2_p_2[1])>?t_2_p_3[1]);
       t2_ymin=((t_2_p_1[1]<?t_2_p_2[1])<?t_2_p_3[1]);
       t2_yradius=(t2_ymax-t2_ymin)/2;
       t2_ycenter=t2_ymin+t2_yradius;
       
       t2_zmax=((t_2_p_1[2]>?t_2_p_2[2])>?t_2_p_3[2]);
       t2_zmin=((t_2_p_1[2]<?t_2_p_2[2])<?t_2_p_3[2]);
       t2_zradius=(t2_zmax-t2_zmin)/2;
       t2_zcenter=t2_zmin+t2_zradius;
       
       if((t1_xcenter<?t2_xcenter)+t1_xradius+t2_xradius > (t1_xcenter>?t2_xcenter)){
              if((t1_ycenter<?t2_ycenter)+t1_yradius+t2_yradius > (t1_ycenter>?t2_ycenter)){
                     if((t1_zcenter<?t2_zcenter)+t1_zradius+t2_zradius > (t1_zcenter>?t2_zcenter)){
                            return(1);
                     }
              }
       }
       return(0);
}


export double model_get_radius(double model_id){
       
       int i;
       double radius=0,vdata;
       
       if(G_modellist.size()>model_id){
              for(i=0;i<G_modellist[(int) model_id].size();i+=1){
                      vdata=G_modellist[(int) model_id][i];
                      if(vdata > radius){
                             radius=vdata*1.5;
                      }
              }
       }
       return(radius);
}


export double sphere_sphere_intersect(double x1,double y1,double z1,double radius1, double x2,double y2,double z2,double radius2){
       double var = sqrt(   pow(x2-x1,2)+pow(y2-y1,2)+pow(z2-z1,2)   );
       if(var>=radius1+radius2){
              return(1);
       }else{
              return(0);
       }
}

double degtorad(double deg){
       return(deg*(0.0174533));
}

export double apply_rotation2(double *point,double model){
       
      double xrotate1,xrotate2,yrotate1,yrotate2,zrotate1,zrotate2;
      double argument0=point[0];
      double argument1=point[1];
      double argument2=point[2];
      double argument3=G_modelrot[(int) model][0];
      double argument4=G_modelrot[(int) model][1];
      double argument5=G_modelrot[(int) model][2];
      //rotation about X axis:
      if(argument3!=0){
         xrotate1 = argument0;
         yrotate1 = cos(degtorad(-argument3))*argument1 - sin(degtorad(-argument3))*argument2;
         zrotate1 = sin(degtorad(-argument3))*argument1 + cos(degtorad(-argument3))*argument2;
      }else{
         xrotate1 = argument0;
         yrotate1 = argument1;
         zrotate1 = argument2;
      }

      //rotation about Y axis:
      if(argument4!=0){
         xrotate2 = cos(degtorad(-argument4))*xrotate1 + sin(degtorad(-argument4))*zrotate1;
         yrotate2 = yrotate1;
         zrotate2 = -sin(degtorad(-argument4))*xrotate1 + cos(degtorad(-argument4))*zrotate1;
      }else{
         xrotate2 = xrotate1;
         yrotate2 = yrotate1;
         zrotate2 = zrotate1;
      }
      //rotation about Z axis:
      if(argument5!=0){
         point[0] = cos(degtorad(-argument5))*xrotate2 - sin(degtorad(-argument5))*yrotate2;
         point[1] = sin(degtorad(-argument5))*xrotate2 + cos(degtorad(-argument5))*yrotate2;
         point[2] = zrotate2;
      }else{
         point[0] = xrotate2;
         point[1] = yrotate2;
         point[2] = zrotate2;
      }
      return 1; 
}

double clear_rotations(){//clear the stored rotation values to 0
       for(int mod=0;mod<2;mod++){
             for(int rot=0;rot<3;rot++){
                   G_modelrot[mod][rot]=0;
             }
       }
       return 1;
}

export double set_rotations_enable(double enable){
       if(enable>0){
          G_rotations_enabled = 1;
       }else{
          G_rotations_enabled = 0;
       }
       return G_rotations_enabled;
}

export double get_rotations_enable(){
       return G_rotations_enabled;
}

export double set_rotations(double xrot0,double yrot0,double zrot0,double xrot1,double yrot1,double zrot1){
       G_modelrot[0][0]=xrot0;
       G_modelrot[0][1]=yrot0;
       G_modelrot[0][2]=zrot0;
       
       G_modelrot[1][0]=xrot1;
       G_modelrot[1][1]=yrot1;
       G_modelrot[1][2]=zrot1;
       
       return 1;
}


export double apply_p_rotation(double vx, double vy, double vz, double model, double returnval){//applies a rotation to a 3d point.
       
       double nx,ny,nz,newx,newy,newz;
       
       // Process vertex rotations 
       // X rot 
       ny = (cos(G_modelrot[0][0]) * vy) - (sin(G_modelrot[0][0]) * vz);
       nz = (sin(G_modelrot[0][0]) * vy) + (cos(G_modelrot[0][0]) * vz);
       newy = ny;
       newz = nz;
       // Y rot
       nx = (cos(G_modelrot[0][0]) * vx) + (sin(G_modelrot[0][0]) * newz);
       nz = (cos(G_modelrot[0][0]) * newz) - (sin(G_modelrot[0][0]) * vx);
       newx = nx;
       newz = nz;
       // Z rot
       nx = (cos(G_modelrot[0][2]) * newx) - (sin(G_modelrot[0][2]) * newy);
       ny = (sin(G_modelrot[0][2]) * newx) + (cos(G_modelrot[0][2]) * newy);
       newx = nx;
       newy = ny;

       if(returnval == 0){
              return newx;
       }else if(returnval == 1){
             return newy;
       }else if(returnval == 2){
             return newz;
       }
       //return 1;
       //return 10;
}

export double absolute_value(double var){
       if(var<0){
             return(-var);
       }else{
             return(var);
       }
       //return(abs((int) var));
}

export double rotate_my_point(double x, double y, double z, double model){//Used for testing rotation function
       G_buffervector[0]=x;
       G_buffervector[1]=y;
       G_buffervector[2]=z;
       apply_rotation2(G_buffervector, model);
       return 1;
}
