#define scr_shader_init
// scr_shader_init()
// Shader Extension

// Version: 1.4
// Updated: 22/Dec/2010
// by LSnK


var file_shaderdll;
file_shaderdll = "shader.dll";


global.dll_shader_init                       = external_define( file_shaderdll, "init",                       dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_d3d_dev_get_name           = external_define( file_shaderdll, "d3d_dev_get_name",           dll_cdecl, ty_string, 0                                                                                          );
global.dll_shader_d3d_dev_get_point_max_size = external_define( file_shaderdll, "d3d_dev_get_point_max_size", dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_d3d_dev_get_ps_version     = external_define( file_shaderdll, "d3d_dev_get_ps_version",     dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_d3d_dev_get_tex_max_width  = external_define( file_shaderdll, "d3d_dev_get_tex_max_width",  dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_d3d_dev_get_tex_max_height = external_define( file_shaderdll, "d3d_dev_get_tex_max_height", dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_d3d_dev_get_tex_max_stages = external_define( file_shaderdll, "d3d_dev_get_tex_max_stages", dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_d3d_dev_get_tex_mem        = external_define( file_shaderdll, "d3d_dev_get_tex_mem",        dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_d3d_ps_create              = external_define( file_shaderdll, "d3d_ps_create",              dll_cdecl, ty_real, 1, ty_string                                                                                 );
global.dll_shader_d3d_ps_destroy             = external_define( file_shaderdll, "d3d_ps_destroy",             dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_ps                 = external_define( file_shaderdll, "d3d_set_ps",                 dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_ps_ext             = external_define( file_shaderdll, "d3d_set_ps_ext",             dll_cdecl, ty_real, 2, ty_real, ty_real                                                                          );
global.dll_shader_d3d_set_ps_const           = external_define( file_shaderdll, "d3d_set_ps_const",           dll_cdecl, ty_real, 5, ty_real, ty_real, ty_real, ty_real, ty_real                                               );
global.dll_shader_d3d_set_ps_const_col       = external_define( file_shaderdll, "d3d_set_ps_const_col",       dll_cdecl, ty_real, 3, ty_real, ty_real, ty_real                                                                 );
global.dll_shader_d3d_set_ps_conf            = external_define( file_shaderdll, "d3d_set_ps_conf",            dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_vs_create              = external_define( file_shaderdll, "d3d_vs_create",              dll_cdecl, ty_real, 1, ty_string                                                                                 );
global.dll_shader_d3d_vs_destroy             = external_define( file_shaderdll, "d3d_vs_destroy",             dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_vs                 = external_define( file_shaderdll, "d3d_set_vs",                 dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_vs_const           = external_define( file_shaderdll, "d3d_set_vs_const",           dll_cdecl, ty_real, 5, ty_real, ty_real, ty_real, ty_real, ty_real                                               );
global.dll_shader_d3d_set_vs_const_col       = external_define( file_shaderdll, "d3d_set_vs_const_col",       dll_cdecl, ty_real, 3, ty_real, ty_real, ty_real                                                                 );
global.dll_shader_d3d_set_vs_const_matrix    = external_define( file_shaderdll, "d3d_set_vs_const_matrix",    dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_vs_conf            = external_define( file_shaderdll, "d3d_set_vs_conf",            dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_tex                = external_define( file_shaderdll, "d3d_set_tex",                dll_cdecl, ty_real, 2, ty_real, ty_real                                                                          );
global.dll_shader_d3d_set_tex_all            = external_define( file_shaderdll, "d3d_set_tex_all",            dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_tex_int            = external_define( file_shaderdll, "d3d_set_tex_int",            dll_cdecl, ty_real, 2, ty_real, ty_real                                                                          );
global.dll_shader_d3d_set_tex_wrap           = external_define( file_shaderdll, "d3d_set_tex_wrap",           dll_cdecl, ty_real, 3, ty_real, ty_real, ty_real                                                                 );
global.dll_shader_d3d_set_tex_border         = external_define( file_shaderdll, "d3d_set_tex_border",         dll_cdecl, ty_real, 3, ty_real, ty_real, ty_real                                                                 );
global.dll_shader_d3d_set_tex_conf           = external_define( file_shaderdll, "d3d_set_tex_conf",           dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_conf_ps_create         = external_define( file_shaderdll, "d3d_conf_ps_create",         dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_d3d_conf_ps_set            = external_define( file_shaderdll, "d3d_conf_ps_set",            dll_cdecl, ty_real, 6, ty_real, ty_real, ty_real, ty_real, ty_real, ty_real                                      );
global.dll_shader_d3d_conf_vs_create         = external_define( file_shaderdll, "d3d_conf_vs_create",         dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_d3d_conf_vs_set            = external_define( file_shaderdll, "d3d_conf_vs_set",            dll_cdecl, ty_real, 6, ty_real, ty_real, ty_real, ty_real, ty_real, ty_real                                      );
global.dll_shader_d3d_conf_tex_create        = external_define( file_shaderdll, "d3d_conf_tex_create",        dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_d3d_conf_tex_set           = external_define( file_shaderdll, "d3d_conf_tex_set",           dll_cdecl, ty_real, 6, ty_real, ty_real, ty_real, ty_real, ty_real, ty_real                                      );
global.dll_shader_d3d_set_fog_state          = external_define( file_shaderdll, "d3d_set_fog_state",          dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_fog_type           = external_define( file_shaderdll, "d3d_set_fog_type",           dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_fog_density        = external_define( file_shaderdll, "d3d_set_fog_density",        dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_fog_color          = external_define( file_shaderdll, "d3d_set_fog_color",          dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_fog_start          = external_define( file_shaderdll, "d3d_set_fog_start",          dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_fog_end            = external_define( file_shaderdll, "d3d_set_fog_end",            dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_point_size         = external_define( file_shaderdll, "d3d_set_point_size",         dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_point_size_min     = external_define( file_shaderdll, "d3d_set_point_size_min",     dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_point_size_max     = external_define( file_shaderdll, "d3d_set_point_size_max",     dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_point_scale        = external_define( file_shaderdll, "d3d_set_point_scale",        dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_point_scale_coef   = external_define( file_shaderdll, "d3d_set_point_scale_coef",   dll_cdecl, ty_real, 3, ty_real, ty_real, ty_real                                                                 );
global.dll_shader_d3d_set_point_sprite       = external_define( file_shaderdll, "d3d_set_point_sprite",       dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_mask               = external_define( file_shaderdll, "d3d_set_mask",               dll_cdecl, ty_real, 4, ty_real, ty_real, ty_real, ty_real                                                        );
global.dll_shader_d3d_set_zwrite             = external_define( file_shaderdll, "d3d_set_zwrite",             dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_alphatest          = external_define( file_shaderdll, "d3d_set_alphatest",          dll_cdecl, ty_real, 2, ty_real, ty_real                                                                          );
global.dll_shader_d3d_set_ztest              = external_define( file_shaderdll, "d3d_set_ztest",              dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_zbias              = external_define( file_shaderdll, "d3d_set_zbias",              dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_fillmode           = external_define( file_shaderdll, "d3d_set_fillmode",           dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_set_normal_auto        = external_define( file_shaderdll, "d3d_set_normal_auto",        dll_cdecl, ty_real, 1, ty_real                                                                                   );
global.dll_shader_d3d_primitive_begin_ext    = external_define( file_shaderdll, "d3d_primitive_begin_ext",    dll_cdecl, ty_real, 2, ty_real, ty_real                                                                          );
global.dll_shader_d3d_vertex_ext             = external_define( file_shaderdll, "d3d_vertex_ext",             dll_cdecl, ty_real, 10, ty_real, ty_real, ty_real, ty_real, ty_real, ty_real, ty_real, ty_real, ty_real, ty_real );
global.dll_shader_d3d_vertex_ext_tex         = external_define( file_shaderdll, "d3d_vertex_ext_tex",         dll_cdecl, ty_real, 3, ty_real, ty_real, ty_real                                                                 );
global.dll_shader_d3d_vertex_ext_next        = external_define( file_shaderdll, "d3d_vertex_ext_next",        dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_d3d_primitive_end_ext      = external_define( file_shaderdll, "d3d_primitive_end_ext",      dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_draw_primitive_begin_ext   = external_define( file_shaderdll, "draw_primitive_begin_ext",   dll_cdecl, ty_real, 2, ty_real, ty_real                                                                          );
global.dll_shader_draw_vertex_ext            = external_define( file_shaderdll, "draw_vertex_ext",            dll_cdecl, ty_real, 6, ty_real, ty_real, ty_real, ty_real, ty_real, ty_real                                      );
global.dll_shader_draw_vertex_ext_tex        = external_define( file_shaderdll, "draw_vertex_ext_tex",        dll_cdecl, ty_real, 3, ty_real, ty_real, ty_real                                                                 );
global.dll_shader_draw_vertex_ext_next       = external_define( file_shaderdll, "draw_vertex_ext_next",       dll_cdecl, ty_real, 0                                                                                            );
global.dll_shader_draw_primitive_end_ext     = external_define( file_shaderdll, "draw_primitive_end_ext",     dll_cdecl, ty_real, 0                                                                                            );


external_call( global.dll_shader_init );





#define d3d_dev_get_name
// d3d_dev_get_name()
// GPU name.


return external_call( global.dll_shader_d3d_dev_get_name );






#define d3d_dev_get_point_max_size
// d3d_dev_get_point_max_size()
// Maximum point primitive size.


return external_call( global.dll_shader_d3d_dev_get_point_max_size );






#define d3d_dev_get_ps_version
// d3d_dev_get_ps_version()
// GPU's pixel shader version.  10 - 14.
// If < 10, pixel shaders are not supported.


return external_call(global.dll_shader_d3d_dev_get_ps_version);

#define d3d_dev_get_tex_max_width
// d3d_dev_get_tex_max_width()
// Maximum texture width.  Applies to all graphical resources.


return external_call( global.dll_shader_d3d_dev_get_tex_max_width );






#define d3d_dev_get_tex_max_height
// d3d_dev_get_tex_max_height()
// Height.


return external_call( global.dll_shader_d3d_dev_get_tex_max_height );






#define d3d_dev_get_tex_max_stages
// d3d_dev_get_tex_max_stages()
// Maximum simultaneous textures.  Limits number of textures addressable in a shader.


return external_call( global.dll_shader_d3d_dev_get_tex_max_stages );






#define d3d_dev_get_tex_mem
// d3d_dev_get_tex_mem()
// Free texture memory in bytes.  Approximate.  NOT the VRAM size!


return external_call( global.dll_shader_d3d_dev_get_tex_mem );






#define d3d_ps_create
// d3d_ps_create( src_asm )
// Assemble and create pixel shader.  Returns index for use in other shader functions.

/*
  Pixel shaders replace normal drawing while enabled.  Colour blending and
  texturing must be handled by the shader.  (See examples in gmk/scr_define_shaders)
  
  Shaders don't affect alpha testing or fog and can be used together with
  blend modes.  The GPU does these after shading.
*/


return external_call( global.dll_shader_d3d_ps_create, argument0 );


#define d3d_ps_destroy
// d3d_ps_destroy( shader )
// Free memory used by a shader, destroying it.


return external_call( global.dll_shader_d3d_ps_destroy, argument0 );






#define d3d_set_ps
// d3d_set_ps( shader )
// Set current pixel shader.  Shaders work with all other render states, including blend modes.


return external_call( global.dll_shader_d3d_set_ps, argument0 );






#define d3d_set_ps_const
// d3d_set_ps_const( constant, r, g, b, a )
// Set pixel shader constant register.
// There are 8 registers indexed 0-7 each containing 4 values between -1 and 1.
// Equivalent to using "def" in shader assembly.


return external_call( global.dll_shader_d3d_set_ps_const, argument0, argument1, argument2, argument3, argument4 );






#define d3d_set_ps_const_col
// d3d_set_ps_const_col( constant, col, alpha )
// Set PS constant as colour.  Handy shortcut.


return external_call( global.dll_shader_d3d_set_ps_const_col, argument0, argument1, argument2 );






#define d3d_set_ps_conf
// d3d_set_ps_conf( conf )
// Set PS constants from a predefined configuration.
// Unset values do not override current ones.
// Much faster than specifying settings individually.


return external_call( global.dll_shader_d3d_set_ps_conf, argument0 );






#define d3d_vs_create
// d3d_vs_create( src_asm )
// Assembles and creates vertex shader.  Returns handle.

/*
  When a vertex shader is enabled it takes over transform and lighting
  completely - this means you have to do EVERYTHING yourself.
  
  See gmk/scr_define_shaders for an example (very bottom of the script).

  The vn input registers are preset as follows:
  
    Reg     Data                 Format
    
    v0:     Position             XYZ
    v3:     Normal               XYZ
    v5:     Diffuse colour       RGBA
    v6:     Specular colour      RGBA
    v7-v14: Texture coords       XY
    
  
   
*/


return external_call( global.dll_shader_d3d_vs_create, argument0 );






#define d3d_vs_destroy
// d3d_vs_destroy( shader )
// Free vertex shader.


return external_call( global.dll_shader_d3d_vs_destroy, argument0 );






#define d3d_set_vs
// d3d_set_vs( shader )
// Set current vertex shader or -1 for none.
// GM resets this automatically when drawing with its own functions.


return external_call( global.dll_shader_d3d_set_vs, argument0 );






#define d3d_set_vs_const
// d3d_set_vs_const( constant, x, y, z, w )
// Set VS constant register.  There are 96.
// Same format as PS constant but with less strict numerical range limits.


return external_call( global.dll_shader_d3d_set_vs_const, argument0, argument1, argument2, argument3, argument4 );






#define d3d_set_vs_const_col
// d3d_set_vs_const_col( constant, col, alpha )
// Set VS constant as colour.  Handy shortcut.


return external_call( global.dll_shader_d3d_set_vs_const_col, argument0, argument1, argument2 );






#define d3d_set_vs_const_matrix
// scr_d3d_set_vs_const_matrix( constant )
// Sets four constants as the transposed world*view*projection matrix.
// You can then use "m4x4 oPos,v0,cn" in the shader to transform the
// vertices in keeping with GM's normal behaviour.

// Example: 0 would set c0,c1,c2,c3; 4 would set c4,c5,c6,c7.


return external_call( global.dll_shader_d3d_set_vs_const_matrix, argument0 );


#define d3d_set_vs_conf
// d3d_set_vs_conf( conf )
// Set VS constant registers from a predefined configuration.
// Constants not set in the config aren't overwritten.


return external_call( global.dll_shader_d3d_set_vs_conf, argument0 );






#define d3d_set_tex
// d3d_set_tex( stage, tex )
// Set texture for this texture stage, or -1 for none.
// Be sure to unset textures before deleting them.
// Read tex in shader with (texld rn,t0).


return external_call( global.dll_shader_d3d_set_tex, argument0, argument1 );






#define d3d_set_tex_all
// d3d_set_tex_all( tex )
// Set all texture stages at once.  -1 unsets all.


return external_call( global.dll_shader_d3d_set_tex_all, argument0 );

#define d3d_set_tex_int
// d3d_set_tex_int( stage, mode )
// Set texture stage interpolation mode.
// Use tex_int_ constant.
// Defaults to tex_int_nearest.
// Stage 0 is also controlled by texture_set_interpolation in GM.


return external_call( global.dll_shader_d3d_set_tex_int, argument0, argument1 );






#define d3d_set_tex_wrap
// d3d_set_tex_wrap( stage, xmode, ymode )
// Set texture stage wrapping mode.  Use tex_wrap_ constant.


return external_call( global.dll_shader_d3d_set_tex_wrap, argument0, argument1, argument2 );




#define d3d_set_tex_border
// d3d_set_tex_border( stage, col, alpha )
// Set colour for tex_wrap_border mode.


return external_call( global.dll_shader_d3d_set_tex_border, argument0, argument1, argument2 );




#define d3d_set_tex_conf
// d3d_set_tex_conf( conf )
// Set texture stage state from a predefined configuration.


return external_call( global.dll_shader_d3d_set_tex_conf, argument0 );






#define d3d_conf_ps_create
// d3d_conf_ps_create()
// Creates new pixel shader configuration and returns its index.


return external_call( global.dll_shader_d3d_conf_ps_create );






#define d3d_conf_ps_set
// d3d_conf_ps_set( conf, constant, r, g, b, a )
// Defines PS constant configuration.


return external_call( global.dll_shader_d3d_conf_ps_set, argument0, argument1, argument2, argument3, argument4, argument5 );






#define d3d_conf_vs_create
// d3d_conf_vs_create()
// Creates new vertex shader configuration and returns its index.


return external_call( global.dll_shader_d3d_conf_vs_create );






#define d3d_conf_vs_set
// d3d_conf_vs_set( conf, constant, x, y, z, w )
// Defines VS constant configuration.


return external_call( global.dll_shader_d3d_conf_vs_set, argument0, argument1, argument2, argument3, argument4, argument5 );






#define d3d_conf_tex_create
// d3d_conf_tex_create()
// Creates new texture stage configuration and returns its index.


return external_call( global.dll_shader_d3d_conf_tex_create );






#define d3d_conf_tex_set
// d3d_conf_tex_set( conf, stage, tex, interp, xmode, ymode )
// Define texture stage settings.


return external_call( global.dll_shader_d3d_conf_tex_set, argument0, argument1, argument2, argument3, argument4, argument5 );






#define d3d_set_fog_state
// d3d_set_fog_state( state )
// Enable/disable fog without modifying fog settings.


return external_call( global.dll_shader_d3d_set_fog_state, argument0 );






#define d3d_set_fog_type
// d3d_set_fog_type( fog_type )
// Set fog type.
// Use fog_type_ constants.
// GM normally uses fog_type_linear; fog_type_exp is better.


return external_call( global.dll_shader_d3d_set_fog_type, argument0 );






#define d3d_set_fog_density
// d3d_set_fog_density( density )
// Controls exponential fog density.  0-1.


return external_call( global.dll_shader_d3d_set_fog_density, argument0 );






#define d3d_set_fog_color
// d3d_set_fog_color( col )
// Set fog colour.


return external_call( global.dll_shader_d3d_set_fog_color, argument0 );






#define d3d_set_fog_start
// d3d_set_fog_start( dist )
// Set fog start.


return external_call( global.dll_shader_d3d_set_fog_start, argument0 );






#define d3d_set_fog_end
// d3d_set_fog_end( dist )
// Set fog end.


return external_call( global.dll_shader_d3d_set_fog_end, argument0 );






#define d3d_set_point_size
// d3d_set_point_size( size )
// Set size of pr_pointlist primitives.
// Clamped between the min and max values when drawing.


return external_call( global.dll_shader_d3d_set_point_size, argument0 );






#define d3d_set_point_size_min
// d3d_set_point_size_min( size )
// Set size clamp, useful for scaled points in 3D mode.  Defaults to 1.


return external_call( global.dll_shader_d3d_set_point_size_min, argument0 );






#define d3d_set_point_size_max
// d3d_set_point_size_max( size )
// Set size clamp, useful for scaled points in 3D mode.  Defaults to 64.


return external_call( global.dll_shader_d3d_set_point_size_max, argument0 );






#define d3d_set_point_scale
// d3d_set_point_scale( state )
// Enable/disable point scaling.
// This scales points based on their distance from the camera.
// You must configure the scaling with d3d_set_point_scale_ceof.


return external_call( global.dll_shader_d3d_set_point_scale, argument0 );






#define d3d_set_point_scale_coef
// d3d_set_point_scale_coef( coef1, coef2, coef3 )
// Configure point scaling formula.  Defaults to (1,0,0).
// The formula is:  size * sqrt(1/( ceof1 + (coef2*distancetocamera) + (coef3*sqr(distancetocamera)) ))


return external_call( global.dll_shader_d3d_set_point_scale_coef, argument0, argument1, argument2 );






#define d3d_set_point_sprite
// d3d_set_point_sprite( state )
// Enabling causes pr_pointlists to be drawn with textures applied.

// NOTE: You must define a texture for the primitive with draw_primitive_begin_texture or similar.
//       Texcoords are ignored.  0,0 -> 1,1 covers the entire point irrespective of your inputs.


return external_call( global.dll_shader_d3d_set_point_sprite, argument0 );






#define d3d_set_mask
// d3d_set_mask( r, g, b, a )
// Enable/disable writing of each colour channel independently.


return external_call( global.dll_shader_d3d_set_mask, argument0, argument1, argument2, argument3 );






#define d3d_set_zwrite
// d3d_set_zwrite( state )
// Enable/disable depth buffer writing.
// Disable to prevent overwriting z-buffer.
// Defaults to enabled.


return external_call( global.dll_shader_d3d_set_zwrite, argument0 );






#define d3d_set_zbias
// d3d_set_zbias( bias )
// Offsets drawing depth, allowing polygons with the same positions
// to be drawn without z-fighting / flickering artifacts.  Useful for shadows, decals, etc.
// Objects drawn with higher values appear in front.
// Integer 0-16, 0 disables.  0 by default.


return external_call( global.dll_shader_d3d_set_zwrite, argument0 );






#define d3d_set_alphatest
// d3d_set_alphatest( value, mode )
// Prevent drawing of pixels that fail the given alpha test.
// Value is 0-255.
// Use cmp_ constants for mode.
// Pass -1 as value to disable alpha testing.  Any positive value enables.
// Because it causes less pixels to be drawn, alphatesting can enhance performance.


return external_call( global.dll_shader_d3d_set_alphatest, argument0, argument1 );






#define d3d_set_ztest
// d3d_set_ztest( mode )
// Prevents drawing of pixels that don't meet the given depth criteria.
// Comparison is between current depth buffer and pixel depth.
// Use cmp_ constants.
// Defaults to cmp_lessequal.



return external_call( global.dll_shader_d3d_set_ztest, argument0 );






#define d3d_set_fillmode
// d3d_set_fillmode( mode )
// Render as points, wireframes or solid.
// Use fillmode_ constants.
// Defaults to fillmode_solid.


return external_call( global.dll_shader_d3d_set_fillmode, argument0 );






#define d3d_set_normal_auto
// d3d_set_normal_auto( state )
// Enable/disable automatic normal-vector normalisation.
// Should solve problems with model lighting when scaling.


return external_call( global.dll_shader_d3d_set_normal_auto, argument0 );






#define d3d_primitive_begin_ext
// d3d_primitive_begin_ext( primitive, textured )
// Begin drawing an extended primitive.  8192 vertices max.

/* 
    NOTE, when drawing textured things work a little differently.
    Obviously I couldn't make a function with 22 arguments, so you have to specify
    texture coordinates separately for each vertex with d3d_vertex_ext_tex.

    Drawing untextured works the same:
          d3d_primitive_begin_ext( pr_trianglestrip, false )
            d3d_vertex_ext()
            d3d_vertex_ext()
            d3d_vertex_ext()
          d3d_primitive_end_ext()

          
    Drawing WITH textures works like this:
          d3d_primitive_begin_ext( pr_trianglestrip, true )
            d3d_vertex_ext()
            d3d_vertex_ext_tex()     // Define up to 8 sets of texcoords.
            d3d_vertex_ext_next()    // Finalises the current vertex.
            d3d_vertex_ext()
            d3d_vertex_ext_tex()
          d3d_primitive_end_ext()    // Draw
    
    Textures are controlled by the d3d_set_tex functions.
    To draw with no textures, use d3d_set_tex_all(-1) to unbind all texture stages.
    
    The specular colour isn't normally drawn, but can be used in a
    vertex/pixel shader as another input.  Like the normal colour, it interpolates
    between vertices.
*/


return external_call( global.dll_shader_d3d_primitive_begin_ext, argument0, argument1 );






#define d3d_vertex_ext
// d3d_vertex_ext( x,y,z, nx,ny,nz, col,alpha, speccol,specalpha )
// Position, normal, diffuse/specular colour and alpha.  Set unused params to zero.


return external_call( global.dll_shader_d3d_vertex_ext, argument0, argument1, argument2, argument3, argument4, argument5, argument6, argument7, argument8, argument9 );






#define d3d_vertex_ext_tex
// d3d_vertex_ext_tex( stage, xtex, ytex )
// Set vertex texture coordinates.  There are eight sets indexed 0-7, one for each texture stage.


return external_call( global.dll_shader_d3d_vertex_ext_tex, argument0, argument1, argument2 );






#define d3d_vertex_ext_next
// d3d_vertex_ext_next()
// Call when finished with the current vertex to start defining the next one.


return external_call( global.dll_shader_d3d_vertex_ext_next );






#define d3d_primitive_end_ext
// d3d_primitive_end_ext()
// Draw the primitive.


return external_call( global.dll_shader_d3d_primitive_end_ext );






#define draw_primitive_begin_ext
// draw_primitive_begin_ext( primitive, textured )
// 2D equivalent.


return external_call( global.dll_shader_draw_primitive_begin_ext, argument0, argument1 );






#define draw_vertex_ext
// draw_vertex_ext( x, y, col, alpha, speccol, specalpha )
// 2D equivalent.


return external_call( global.dll_shader_draw_vertex_ext, argument0, argument1, argument2, argument3, argument4, argument5 );






#define draw_vertex_ext_tex
// draw_vertex_ext_tex( stage, xtex, ytex )
// 2D equivalent.


return external_call( global.dll_shader_draw_vertex_ext_tex, argument0, argument1, argument2 );






#define draw_vertex_ext_next
// draw_vertex_ext_next()
// 2D equivalent.


return external_call( global.dll_shader_draw_vertex_ext_next );






#define draw_primitive_end_ext
// draw_primitive_end_ext()
// 2D equivalent.


return external_call( global.dll_shader_draw_primitive_end_ext );






