// This vertex shader is used to do normal mapped diffuse and specular lighting
vs.1.1

// Compute the projection space vertex position
m4x4 oPos, v0, c0

// The first texture coordinate gets the texture coordinate of the mesh
mov oT0, v7

// The second texture coordinate gets a tangent space camera to vertex vector
sub r0, v0, c4
dp3 oT1.x, r0, v8
dp3 oT1.y, r0, v9
dp3 oT1.z, r0, v3

// The third texture coordinate gets a tangent space light 1 to vertex vector
//sub r0, v0, c5
mov r0, c5
dp3 oT2.x, r0, v8
dp3 oT2.y, r0, v9
dp3 oT2.z, r0, v3

// The forth texture coordinate gets a tangent space light 2 to vertex vector
sub r2, v0, c9
dp3 oT3.x, r2, v8
dp3 oT3.y, r2, v9
dp3 oT3.z, r2, v3

// Compute the range based attenuation factor through the following formula:
// A=LightRange / (d*16)
// ITS A TRAP!
//dp3 r0.w, r0, r0
//rcp r0.w, r0.w
//mul r1.w, c5.w, c5.w
//mul r1.w, r1.w, c7.w
//rcp r1.w, r1.w
//mul r0.w, r0.w, r1.w

// Compute the range based attenuation factor through the following formula:
// A=LightRange / (d*16)
dp3 r2.w, r2, r2
rcp r2.w, r2.w
mul r3.w, c9.w, c9.w
mul r3.w, r3.w, c7.w
rcp r3.w, r3.w
mul r2.w, r2.w, r3.w

// Multiply the color component of the material color by the attenuation factor and 
// the light color to get the final diffuse color and pass the alpha component
//mul r0.rgb, c6.rgb, r0.w
//mul oD0.rgb, r0.rgb, c8
//mov oD0.a, c6.a

//mul r0.rgb, c8, r0.w
mov r0.rgb, c8
mul r2.rgb, c10, r2.w
add r0.rgb, r0, r2

mul oD0.rgb, r0.rgb, c6
mov oD0.a, c6.a
