uniform sampler2D bufferTexture;
uniform vec2 viewSize;
uniform float blurRadius;

void main(void)
{
    vec4 total = vec4(0.0, 0.0, 0.0, 1.0);
    vec2 pix = gl_FragCoord.xy;
    vec2 invScreenSize = vec2(1.0 / viewSize.x, 1.0 / viewSize.y);

    for (float ky = -blurRadius; ky <= blurRadius; ky++)
    {
        vec4 col = texture2D(bufferTexture, gl_TexCoord[0].xy + vec2(0.0, ky) * invScreenSize);
        float lum = col.r * 0.2126 + col.g * 0.7152 + col.b * 0.0722;
        total += col * (lum * 1.5);
    }

    total /= blurRadius * 2.0;
        
    gl_FragColor = total;
    gl_FragColor.a = 1.0;
}
