uniform sampler2D bufferTexture;
uniform vec2 viewSize;
uniform float blurRadius;

void main(void)
{
    vec4 total = vec4(0.0, 0.0, 0.0, 1.0);
    vec2 pix = gl_FragCoord.xy;
    vec2 invScreenSize = vec2(1.0 / viewSize.x, 1.0 / viewSize.y);

    for (float kx = -blurRadius; kx <= blurRadius; kx++)
    {
        vec4 col = texture2D(bufferTexture, gl_TexCoord[0].xy + vec2(kx, 0.0) * invScreenSize);
        total += col;
    }

    total /= blurRadius * 2.0;
        
    gl_FragColor = total;
    gl_FragColor.a = 1.0;
}
