#version 120
varying vec3 position;
varying vec3 n, e, l;
varying vec3 worldView;
varying vec3 worldNormal;

varying vec4 shadowCoord1;
varying vec4 shadowCoord2;
varying vec4 shadowCoord3;

uniform mat4 shadowMatrix1;
uniform mat4 shadowMatrix2;
uniform mat4 shadowMatrix3;

uniform mat4 invViewMatrix;

uniform vec4 sunDir;

void main()
{
    gl_TexCoord[0] = gl_MultiTexCoord0;
    vec4 eyeVertex = gl_ModelViewMatrix * gl_Vertex;
    shadowCoord1 = shadowMatrix1 * eyeVertex;
    shadowCoord2 = shadowMatrix2 * eyeVertex;
    shadowCoord3 = shadowMatrix3 * eyeVertex;
    position = eyeVertex.xyz;
    
    e = -position;
    
    n = gl_NormalMatrix * gl_Normal; //normalize(gl_NormalMatrix * gl_Normal);
    
    vec3 worldPos = (invViewMatrix * eyeVertex).xyz;
    vec3 worldCamPos = (invViewMatrix[3]).xyz;
    worldView = worldPos - worldCamPos;
    
    l = (-sunDir * invViewMatrix).xyz;
    
    worldNormal = gl_Normal.xyz;
   
    gl_Position = ftransform();
}