#version 120
uniform sampler2D bufferTexture;
uniform sampler2D blurredTexture;

const float k = 0.025;
const float kcube = 0.1;
const float scale = 0.84;
const float dispersion = 0.01;

void main()
{
    vec3 eta = vec3(1.0 + dispersion * 0.9, 1.0 + dispersion * 0.6, 1.0 + dispersion * 0.3);
    vec2 texcoord = gl_TexCoord[0].st;
    vec2 cancoord = gl_TexCoord[0].st;
    float r2 = (cancoord.x - 0.5) * (cancoord.x - 0.5) + (cancoord.y - 0.5) * (cancoord.y - 0.5);       
    float f = 0.0;
    f = (kcube == 0.0)? 1.0 + r2 * (k + kcube * sqrt(r2)) : 1.0 + r2 * k;
    vec2 coef = f * scale * (texcoord.xy - 0.5);
    vec2 rCoords = eta.r * coef + 0.5;
    vec2 gCoords = eta.g * coef + 0.5;
    vec2 bCoords = eta.b * coef + 0.5;
    vec4 inputDistort = vec4(0.0); 
    inputDistort.r = texture2D(bufferTexture, rCoords).r;
    inputDistort.g = texture2D(bufferTexture, gCoords).g;
    inputDistort.b = texture2D(bufferTexture, bCoords).b;
    inputDistort.a = 1.0;
    vec4 blurred = vec4(0.0);
    blurred.r = texture2D(blurredTexture, rCoords).r;
    blurred.g = texture2D(blurredTexture, gCoords).g;
    blurred.b = texture2D(blurredTexture, bCoords).b;
    gl_FragColor = inputDistort + pow(blurred, vec4(1.1));
    gl_FragColor.a = 1.0;
}