#version 120

uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D mask;
uniform sampler2D normalmap;
uniform mat4 viewMatrix;

void main()
{
    vec2 texcoords = gl_TexCoord[0].st;
    vec2 tiledTexcoords = texcoords * 100.0;
    
    vec3 N = normalize(texture2D(normalmap, texcoords).rgb * 2.0 - 1.0).xzy;
    N = mat3(viewMatrix) * N;
    
    vec3 L = gl_LightSource[0].position.xyz;
    float diffuse = clamp(dot(N, L), 0.0, 1.0);
    float ambient = 0.2;

    vec4 tex1 = texture2D(texture1, tiledTexcoords);
    vec4 tex2 = texture2D(texture2, tiledTexcoords);
    float mask1 = texture2D(mask, texcoords).r;
    
    vec4 comb1 = tex1 * (1.0 - mask1) + tex2 * mask1;
    
    vec4 finalColor = comb1 * ambient + comb1 * diffuse; 
    
    gl_FragColor = finalColor;
    gl_FragColor.a = 1.0;
}
