uniform sampler2D depthTexture;
uniform sampler2D randomTexture;
uniform vec2 ssaoMapSize;

float linearDepth(vec2 uv)
{
    const float zNear = 0.01; 
    const float zFar  = 100.0; 
    float depth = texture2D(depthTexture, uv).x;
    return (2.0 * zNear) / (zFar + zNear - depth * (zFar - zNear));
}

vec3 normalFromDepth(float depth, vec2 texcoords)
{  
    const vec2 offset1 = vec2(0.0, 0.001);
    const vec2 offset2 = vec2(0.001, 0.0);
  
    float depth1 = linearDepth(texcoords + offset1);
    float depth2 = linearDepth(texcoords + offset2);
  
    vec3 p1 = vec3(offset1, depth1 - depth);
    vec3 p2 = vec3(offset2, depth2 - depth);
  
    vec3 normal = cross(p1, p2);
    normal.z = -normal.z;
  
    return normalize(normal);
}

void main()
{ 
    const float total_strength = 1.0;
    const float base = 0.35;
  
    const float area = 0.01;
    const float falloff = 0.000001;
  
    const float radius = 0.0002;
    const float distScale = 0.7;

    const int samples = 16;
    vec3 sample_sphere[samples]; 
    sample_sphere[0] = vec3( 0.5381, 0.1856,-0.4319);
    sample_sphere[1] = vec3( 0.1379, 0.2486, 0.4430);
    sample_sphere[2] = vec3( 0.3371, 0.5679,-0.0057);
    sample_sphere[3] = vec3(-0.6999,-0.0451,-0.0019);
    sample_sphere[4] = vec3( 0.0689,-0.1598,-0.8547);
    sample_sphere[5] = vec3( 0.0560, 0.0069,-0.1843);
    sample_sphere[6] = vec3(-0.0146, 0.1402, 0.0762);
    sample_sphere[7] = vec3( 0.0100,-0.1924,-0.0344);
    sample_sphere[8] = vec3(-0.3577,-0.5301,-0.4358);
    sample_sphere[9] = vec3(-0.3169, 0.1063, 0.0158);
    sample_sphere[10] = vec3( 0.0103,-0.5869, 0.0046);
    sample_sphere[11] = vec3(-0.0897,-0.4940, 0.3287);
    sample_sphere[12] = vec3( 0.7119,-0.0154,-0.0918);
    sample_sphere[13] = vec3(-0.0533, 0.0596,-0.5411);
    sample_sphere[14] = vec3( 0.0352,-0.0631, 0.5460);
    sample_sphere[15] = vec3(-0.4776, 0.2847,-0.0271);

    vec2 texcoord = gl_TexCoord[0].st;
  
    vec3 random = normalize(texture2D(randomTexture, texcoord * ssaoMapSize / 4.0).rgb);
  
    float depth = linearDepth(texcoord);
 
    vec3 position = vec3(texcoord, depth);
    vec3 normal = normalFromDepth(depth, texcoord);
  
    float radius_depth = radius / depth;
    float occlusion = 0.0;
    for(int i = 0; i < samples; i++)
    {
        vec3 ray = radius_depth * reflect(sample_sphere[i], random);
        vec3 hemi_ray = position + sign(dot(ray, normal)) * ray;
    
        float occ_depth = linearDepth(clamp(hemi_ray.xy, 0.0, 1.0));
        float difference = (depth - occ_depth) / distScale;
    
        occlusion += step(falloff, difference) * (1.0 - mix(falloff, area, difference));
    }
  
    float ao = 1.0 - total_strength * occlusion * (1.0 / float(samples));
    ao = clamp(ao + base, 0.0, 1.0);
    
    gl_FragColor = vec4(ao, ao, ao, 1.0);
}

