uniform sampler2D bufferTexture;
uniform sampler2D ssaoTexture;
uniform vec2 viewSize;

void main()
{
    vec2 texcoord = gl_TexCoord[0].st;
    
    vec2 invScreenSize = 1.0 / viewSize;
    
    float accum = 0.0;
    float x, y;
    const float size = 2.0;
    for (y = -size; y < size; y += 1.0)
    for (x = -size; x < size; x += 1.0)
        accum += texture2D(ssaoTexture, texcoord + invScreenSize * vec2(x, y)).r;
    accum = accum / (size * size * 4.0);
    
    gl_FragColor = texture2D(bufferTexture, texcoord) * accum; 
    gl_FragColor.a = 1.0;
}
