uniform sampler2D bufferTexture;

uniform vec2 invViewSize; // 1.0 / viewSize

const float blurSize = 0.2;
const vec2 blurOrigin = vec2(0.5, 0.5);
 
void main(void)
{
    vec2 uv = gl_FragCoord.xy * invViewSize;
 
    vec4 color = vec4(0.0, 0.0, 0.0, 0.0);
    uv += invViewSize * 0.5 - blurOrigin;
 
    for (int i = 0; i < 12; i++) 
    {
        float scale = 1.0 - blurSize * (float(i) / 11.0);
        color += texture2D(bufferTexture,  uv * scale + blurOrigin);
    }
 
    gl_FragColor = color / 12.0;
    gl_FragColor.a = 1.0;
}
