uniform sampler2D bufferTexture;
uniform vec2 viewSize;
uniform vec2 blurVector;
const int numSamples = 16;

void main()
{
    vec2 invScreenSize = vec2(1.0 / viewSize.x, 1.0 / viewSize.y);
    vec2 texcoord = gl_TexCoord[0].st;
    vec4 color = texture2D(bufferTexture, texcoord);
    for(int i = 1; i < numSamples; ++i)  
    { 
        vec2 offset = blurVector * invScreenSize * (float(i) / float(numSamples - 1) - 0.5);
        color += texture2D(bufferTexture, texcoord + offset);  
    }
    vec4 finalColor = color / float(numSamples);
    gl_FragColor = finalColor;
}