uniform sampler2D bufferTexture;
uniform vec2 lightPosition;

const float exposure = 1.0;
const float decay = 0.8;
const float density = 1.2;
const float weight = 1.0;
const int NUM_SAMPLES = 40;

    void main()
    {	
    	vec2 deltaTextCoord = vec2( gl_TexCoord[0].st - lightPosition );
    	vec2 textCoo = gl_TexCoord[0].st;
    	deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * density;
    	float illuminationDecay = 1.0;

    	for(int i=0; i < NUM_SAMPLES ; i++)
        {
                 textCoo -= deltaTextCoord;
                 vec4 sample = texture2D(bufferTexture, textCoo );
			
                 sample *= illuminationDecay * weight;

                 gl_FragColor += sample;

                 illuminationDecay *= decay;
         }
         gl_FragColor *= exposure;
         
        gl_FragColor.a = 1.0;
    }
