uniform sampler2D colorTexture;
uniform sampler2D depthTexture;
uniform sampler2D distortionTexture;
uniform sampler2D distortionMask;

uniform vec2 viewSize;
        
const float time = 1.0;
        
const float distortionFactor = 0.05; // Factor used to control severity of the effect
const float riseFactor = 1.0; // Factor used to control how fast air rises

void main()
{        
    vec2 texcoord = gl_FragCoord.xy / viewSize;
    float mask = 1.0; //texture2D(distortionMask, gl_TexCoord[0].st).r;
    float z = (2.0 * gl_FragCoord.z - gl_DepthRange.near - gl_DepthRange.far) / (gl_DepthRange.far - gl_DepthRange.near);

    vec2 distortionMapCoordinate = gl_TexCoord[0].st;
    //distortionMapCoordinate.t -= time * riseFactor;
    vec4 distortionMapValue = texture2D(distortionTexture, distortionMapCoordinate);
    vec2 distortionPositionOffset = (distortionMapValue.xy) * 2.0 * distortionFactor;
    distortionPositionOffset *= (1.0 - gl_TexCoord[0].t);
    vec2 distortedTextureCoordinate = texcoord + distortionPositionOffset;
    vec2 tc = distortedTextureCoordinate * mask + texcoord * (1.0 - mask);
    vec4 col1 = texture2D(colorTexture, tc);

    gl_FragColor = col1 * vec4(0.0, 1.0, 1.0, 1.0);
    gl_FragColor.a = 1.0;
}
