uniform sampler2D bufferTexture;
uniform vec2 viewSize;
uniform float blurRadius;

void main(void)
{
    vec4 total = vec4(0.0, 0.0, 0.0, 1.0);
    vec2 pix = gl_FragCoord.xy;
    vec2 invScreenSize = vec2(1.0 / viewSize.x, 1.0 / viewSize.y);
    
    const vec4 zero = vec4(0.0, 0.0, 0.0, 0.0);

    for (float ky = -blurRadius; ky <= blurRadius; ky++)
    for (float kx = -blurRadius; kx <= blurRadius; kx++)
    {
        total += texture2D(bufferTexture, gl_TexCoord[0].xy + vec2(kx, ky) * invScreenSize);
    }

    total /= blurRadius * blurRadius * 4.0;
        
    gl_FragColor = total;
    gl_FragColor.a = 0.5;
}
